/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.daemon.quickFix.FileReferenceQuickFixProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class PsiFileReferenceHelper
extends FileReferenceHelper {
    @Override
    @NotNull
    public List<? extends LocalQuickFix> registerFixes(FileReference reference) {
        List<? extends LocalQuickFix> list = FileReferenceQuickFixProvider.registerQuickFix(reference);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper", "registerFixes"));
        }
        return list;
    }

    @Override
    public PsiFileSystemItem findRoot(Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper", "findRoot"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        VirtualFile contentRootForFile = index.getSourceRootForFile(file2);
        if (contentRootForFile == null) {
            contentRootForFile = index.getContentRootForFile(file2);
        }
        if (contentRootForFile != null) {
            return PsiManager.getInstance((Project)project2).findDirectory(contentRootForFile);
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module2) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper", "getRoots"));
        }
        Collection<PsiFileSystemItem> collection = PsiFileReferenceHelper.getContextsForModule(module2, "", module2.getModuleWithDependenciesScope());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper", "getRoots"));
        }
        return collection;
    }

    @Override
    @NotNull
    public Collection<PsiFileSystemItem> getContexts(Project project2, @NotNull VirtualFile file2) {
        PsiFileSystemItem parent;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper", "getContexts"));
        }
        PsiFileSystemItem item = this.getPsiFileSystemItem(project2, file2);
        if (item != null && (parent = item.getParent()) != null) {
            Module module2;
            String path;
            ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
            VirtualFile parentFile = parent.getVirtualFile();
            assert (parentFile != null);
            VirtualFile root = index.getSourceRootForFile(parentFile);
            if (root != null && (path = VfsUtilCore.getRelativePath((VirtualFile)parentFile, (VirtualFile)root, (char)'.')) != null && (module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2, (Project)project2)) != null) {
                OrderEntry orderEntry = ModuleRootManager.getInstance((Module)module2).getFileIndex().getOrderEntryForFile(file2);
                if (orderEntry instanceof ModuleSourceOrderEntry) {
                    block0: for (ContentEntry e : ((ModuleSourceOrderEntry)orderEntry).getRootModel().getContentEntries()) {
                        for (SourceFolder sf : e.getSourceFolders(JavaModuleSourceRootTypes.SOURCES)) {
                            String s;
                            if (!root.equals(sf.getFile()) || (s = sf.getPackagePrefix()).isEmpty()) continue;
                            path = s + "." + path;
                            continue block0;
                        }
                    }
                }
                Collection<PsiFileSystemItem> collection = PsiFileReferenceHelper.getContextsForModule(module2, path, module2.getModuleWithDependenciesScope());
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper", "getContexts"));
                }
                return collection;
            }
            Set<PsiFileSystemItem> set = Collections.singleton(parent);
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper", "getContexts"));
            }
            return set;
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper", "getContexts"));
        }
        return list;
    }

    @Override
    public boolean isMine(Project project2, @NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper", "isMine"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        return index.isInSourceContent(file2);
    }

    @Override
    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper", "trimUrl"));
        }
        String string = url.trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper", "trimUrl"));
        }
        return string;
    }

    static Collection<PsiFileSystemItem> getContextsForModule(@NotNull Module module2, @NotNull String packageName, @Nullable GlobalSearchScope scope) {
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper", "getContextsForModule"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/psi/impl/source/resolve/reference/impl/providers/PsiFileReferenceHelper", "getContextsForModule"));
        }
        List<PsiFileSystemItem> result2 = null;
        Query<VirtualFile> query = DirectoryIndex.getInstance(module2.getProject()).getDirectoriesByPackageName(packageName, false);
        PsiManager manager = null;
        for (VirtualFile file2 : query) {
            PsiDirectory psiDirectory;
            if (scope != null && !scope.contains(file2)) continue;
            if (result2 == null) {
                result2 = new ArrayList<PsiFileSystemItem>();
                manager = PsiManager.getInstance((Project)module2.getProject());
            }
            if ((psiDirectory = manager.findDirectory(file2)) == null) continue;
            result2.add((PsiFileSystemItem)psiDirectory);
        }
        return result2 != null ? result2 : Collections.emptyList();
    }
}

