/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.util.ArrayUtil;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class NamesEnumerator {
    static final int NO_NAME = 0;
    private TObjectIntHashMap<byte[]> myAsciiMap = new TObjectIntHashMap((TObjectHashingStrategy)new TObjectHashingStrategy<byte[]>(){

        public int computeHashCode(byte[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(byte[] o1, byte[] o2) {
            return Arrays.equals(o1, o2);
        }
    });
    private TObjectIntHashMap<String> myNonAsciiMap = new TObjectIntHashMap();
    TObjectIntHashMap<int[]> fullNameMap = new TObjectIntHashMap((TObjectHashingStrategy)new TObjectHashingStrategy<int[]>(){

        public int computeHashCode(int[] object) {
            return Arrays.hashCode(object);
        }

        public boolean equals(int[] o1, int[] o2) {
            return Arrays.equals(o1, o2);
        }
    });
    private QualifiedName[] myQualifiedNames = new QualifiedName[32768];

    QualifiedName qualifiedName(int id) {
        return this.myQualifiedNames[id];
    }

    public int getSimpleName(String s, boolean create) {
        byte[] bytes = NamesEnumerator.convertToBytesIfAsciiString(s);
        if (bytes != null) {
            int id = this.myAsciiMap.get((Object)bytes);
            if (id == 0 && create) {
                id = this.myAsciiMap.size() + this.myNonAsciiMap.size() + 1;
                this.myAsciiMap.put((Object)bytes, id);
            }
            return id;
        }
        int id = this.myNonAsciiMap.get((Object)(s = new String(s)));
        if (id == 0 && create) {
            id = this.myAsciiMap.size() + this.myNonAsciiMap.size() + 1;
            this.myNonAsciiMap.put((Object)s, id);
        }
        return id;
    }

    public QualifiedName getFullName(int[] ids, boolean create) {
        int id = this.fullNameMap.get((Object)ids);
        if (id == 0 && create) {
            id = this.fullNameMap.size() + 1;
            this.fullNameMap.put((Object)ids, id);
            this.ensureFullCapacity(id);
            this.myQualifiedNames[id] = new QualifiedName(id, ids);
        }
        return this.myQualifiedNames[id];
    }

    private void ensureFullCapacity(int maxIndex) {
        if (maxIndex >= this.myQualifiedNames.length) {
            int newLength = NamesEnumerator.calculateNewLength(this.myQualifiedNames.length, maxIndex);
            QualifiedName[] names1 = new QualifiedName[newLength];
            System.arraycopy(this.myQualifiedNames, 0, names1, 0, this.myQualifiedNames.length);
            this.myQualifiedNames = names1;
        }
    }

    private static int calculateNewLength(int currentLength, int maxIndex) {
        while (currentLength < maxIndex + 1) {
            currentLength *= 2;
        }
        return currentLength;
    }

    @Nullable
    public static byte[] convertToBytesIfAsciiString(CharSequence name) {
        int length = name.length();
        if (length == 0) {
            return ArrayUtil.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if (c >= '\u0080') {
                return null;
            }
            bytes[i] = (byte)c;
        }
        return bytes;
    }
}

