/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.java.stubs.hierarchy.IndexTree;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubsHierarchy.impl.HierarchyService;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import java.util.BitSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SingleClassHierarchyBuilder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubsHierarchy.HierarchyBuilder");
    private static final boolean TEST_MEMORY_USAGE = false;

    public static void build(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/psi/stubsHierarchy/impl/SingleClassHierarchyBuilder", "build"));
        }
        ProgressManager progress = ProgressManager.getInstance();
        progress.runProcessWithProgressSynchronously((Runnable)new BuildSingleClassHierarchy(project2), "Building Hierarchy", false, project2);
    }

    private static void testMemory(String msg) {
    }

    private static class BuildSingleClassHierarchy
    implements Runnable {
        Project myProject;

        BuildSingleClassHierarchy(Project project2) {
            this.myProject = project2;
        }

        @Override
        public void run() {
            HierarchyService service = HierarchyService.instance(this.myProject);
            if (service.getSingleClassHierarchy() != null) {
                return;
            }
            LOG.info("BuildHierarchy started");
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            double classes = 0.3;
            double completeClasses = 0.1;
            double sources = 0.3;
            double collectPsiFilesFraction = 0.2;
            UnitProcessor processor2 = new UnitProcessor(this.myProject, service);
            LOG.info("read classes start");
            indicator.setText("Reading classes");
            ApplicationManager.getApplication().runReadAction(() -> StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.UNITS, this.myProject, (Processor)processor2));
            indicator.setFraction(0.3);
            SingleClassHierarchyBuilder.testMemory("0");
            LOG.info("complete classes start");
            indicator.setText("Completing classes");
            service.connect1();
            indicator.setFraction(0.4);
            SingleClassHierarchyBuilder.testMemory("1");
            LOG.info("read sources start");
            indicator.setText("Reading sources");
            processor2.isInSourceMode = true;
            ApplicationManager.getApplication().runReadAction(() -> StubIndex.getInstance().processAllKeys(JavaStubIndexKeys.UNITS, this.myProject, (Processor)processor2));
            indicator.setFraction(0.7);
            LOG.info("read PSI start");
            indicator.setText("Collecting PSI Files");
            HashSet srcSet = new HashSet();
            this.collectFiles((Set<VirtualFile>)srcSet, processor2.myProcessedSet);
            double total = srcSet.size();
            LOG.info("Processing PSI");
            indicator.setText("Processing PSI Files");
            int loadedCound = 0;
            for (final VirtualFile vFile : srcSet) {
                PsiFile psiFile;
                String presentableUrl = vFile.getPresentableUrl();
                if (HierarchyService.PROCESS_PSI && (psiFile = (PsiFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<PsiFile>(){

                    public PsiFile compute() {
                        return PsiManager.getInstance((Project)myProject).findFile(vFile);
                    }
                })) instanceof PsiClassOwner) {
                    service.processPsiClassOwner((PsiClassOwner)psiFile);
                    LOG.info("PSI: " + presentableUrl);
                }
                indicator.setFraction(0.7 + 0.2 * ((double)(++loadedCound) / total));
            }
            SingleClassHierarchyBuilder.testMemory("2");
            indicator.setText("Completing sources + PSI");
            service.complete2();
            LOG.info("Complete end");
            SingleClassHierarchyBuilder.testMemory("3");
            indicator.setFraction(0.9);
            indicator.setText("Connecting subtypes");
            service.connectSubtypes();
            LOG.info("Subtypes connected");
            indicator.setFraction(1.0);
        }

        private void collectFiles(final Set<VirtualFile> srcSet, final BitSet processed2) {
            final ProjectFileIndex projectIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
            projectIndex.iterateContent(new ContentIterator(){

                public boolean processFile(VirtualFile fileOrDir) {
                    int fileId = ((VirtualFileWithId)fileOrDir).getId();
                    if (!processed2.get(fileId) && projectIndex.isInSourceContent(fileOrDir)) {
                        srcSet.add(fileOrDir);
                    }
                    return true;
                }
            });
        }
    }

    private static class UnitProcessor
    implements Processor<IndexTree.Unit> {
        private final Project myProject;
        private final HierarchyService myHierarchyService;
        protected final BitSet myProcessedSet = new BitSet();
        private final ProjectFileIndex myProjectIndex;
        boolean isInSourceMode;

        private UnitProcessor(Project project2, HierarchyService hierarchyService) {
            this.myProject = project2;
            this.myHierarchyService = hierarchyService;
            this.myProjectIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
        }

        public boolean process(IndexTree.Unit unit) {
            boolean process2;
            VirtualFile file2 = PersistentFS.getInstance().findFileById(unit.myFileId);
            if (file2 == null) {
                return true;
            }
            boolean bl = process2 = this.isInSourceMode ? this.myProjectIndex.isInSourceContent(file2) : this.myProjectIndex.isInLibraryClasses(file2);
            if (process2) {
                this.myHierarchyService.processUnit(unit);
                this.myProcessedSet.set(unit.myFileId);
            }
            return true;
        }
    }
}

