/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubsHierarchy.impl;

import com.intellij.psi.stubsHierarchy.impl.HierarchyConnector;
import com.intellij.psi.stubsHierarchy.impl.NameEnvironment;
import com.intellij.psi.stubsHierarchy.impl.QualifiedName;
import com.intellij.psi.stubsHierarchy.impl.StubResolver;
import com.intellij.psi.stubsHierarchy.impl.Symbol;
import com.intellij.psi.stubsHierarchy.impl.Symbols;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class StubHierarchyConnector
implements HierarchyConnector {
    private final NameEnvironment myNameEnvironment;
    private final StubResolver myResolve;

    protected StubHierarchyConnector(NameEnvironment nameEnvironment, Symbols symbols) {
        this.myNameEnvironment = nameEnvironment;
        this.myResolve = new StubResolver(symbols);
    }

    @Override
    public void connect(Symbol sym) {
        Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
        if (c.myOwner instanceof Symbol.ClassSymbol) {
            ((Symbol.ClassSymbol)c.myOwner).connect();
        }
        HashSet<Symbol> supertypes = new HashSet<Symbol>();
        for (QualifiedName name : c.mySuperNames) {
            if (c.isCompiled()) {
                if (name == null) continue;
                Collections.addAll(supertypes, this.myResolve.findGlobalType(name));
                continue;
            }
            Set<Symbol> based = this.myResolve.resolveBase(c, name.myComponents);
            supertypes.addAll(based);
        }
        if (c.myQualifiedName == this.myNameEnvironment.java_lang_Object) {
            c.mySuperClasses = Symbol.ClassSymbol.EMPTY_ARRAY;
        } else {
            Iterator iter = supertypes.iterator();
            while (iter.hasNext()) {
                Symbol s = (Symbol)iter.next();
                if (s instanceof Symbol.ClassSymbol && s.myQualifiedName != this.myNameEnvironment.java_lang_Object) continue;
                iter.remove();
            }
            c.mySuperClasses = supertypes.isEmpty() ? Symbol.ClassSymbol.EMPTY_ARRAY : supertypes.toArray(new Symbol.ClassSymbol[supertypes.size()]);
        }
        c.mySuperNames = null;
        c.myUnitInfo = null;
    }
}

