/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineOptionsDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public abstract class InlineOptionsWithSearchSettingsDialog
extends InlineOptionsDialog {
    protected JCheckBox myCbSearchInComments;
    protected JCheckBox myCbSearchTextOccurences;

    protected InlineOptionsWithSearchSettingsDialog(Project project2, boolean canBeParent, PsiElement element) {
        super(project2, canBeParent, element);
    }

    protected abstract boolean isSearchInCommentsAndStrings();

    protected abstract void saveSearchInCommentsAndStrings(boolean var1);

    protected abstract boolean isSearchForTextOccurrences();

    protected abstract void saveSearchInTextOccurrences(boolean var1);

    @Override
    protected void doAction() {
        boolean searchInNonJava = this.myCbSearchTextOccurences.isSelected();
        boolean searchInComments = this.myCbSearchInComments.isSelected();
        if (this.myCbSearchInComments.isEnabled()) {
            this.saveSearchInCommentsAndStrings(searchInComments);
        }
        if (this.myCbSearchTextOccurences.isEnabled()) {
            this.saveSearchInTextOccurrences(searchInNonJava);
        }
    }

    public void setEnabledSearchSettngs(boolean enabled) {
        this.myCbSearchInComments.setEnabled(enabled);
        this.myCbSearchTextOccurences.setEnabled(enabled);
        if (enabled) {
            this.myCbSearchInComments.setSelected(this.isSearchInCommentsAndStrings());
            this.myCbSearchTextOccurences.setSelected(this.isSearchForTextOccurrences());
        } else {
            this.myCbSearchInComments.setSelected(false);
            this.myCbSearchTextOccurences.setSelected(false);
        }
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 2;
        panel.add((Component)super.createCenterPanel(), gbc);
        this.myCbSearchInComments = new JCheckBox(RefactoringBundle.message((String)"search.in.comments.and.strings"), this.isSearchInCommentsAndStrings());
        this.myCbSearchTextOccurences = new JCheckBox(RefactoringBundle.message((String)"search.for.text.occurrences"), this.isSearchForTextOccurrences());
        gbc.weightx = 0.0;
        gbc.gridwidth = 1;
        gbc.gridy = 1;
        gbc.gridx = 0;
        panel.add((Component)this.myCbSearchInComments, gbc);
        gbc.gridx = 1;
        panel.add((Component)this.myCbSearchTextOccurences, gbc);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InlineOptionsWithSearchSettingsDialog.this.setEnabledSearchSettngs(InlineOptionsWithSearchSettingsDialog.this.myRbInlineAll.isSelected());
            }
        };
        this.myRbInlineThisOnly.addActionListener(actionListener);
        this.myRbInlineAll.addActionListener(actionListener);
        this.setEnabledSearchSettngs(this.myRbInlineAll.isSelected());
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/inline/InlineOptionsWithSearchSettingsDialog", "createCenterPanel"));
        }
        return jPanel;
    }
}

