/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceParameter;

import com.intellij.codeInspection.AnonymousCanBeLambdaInspection;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceParameter.IntroduceParameterProcessor;
import com.intellij.refactoring.introduceParameter.IntroduceParameterSettingsUI;
import com.intellij.refactoring.introduceParameter.Util;
import com.intellij.refactoring.ui.NameSuggestionsField;
import com.intellij.refactoring.ui.NameSuggestionsGenerator;
import com.intellij.refactoring.ui.NameSuggestionsManager;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.TypeSelector;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ui.JBUI;
import gnu.trove.TIntArrayList;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class IntroduceParameterDialog
extends RefactoringDialog {
    private static final String INTRODUCE_PARAMETER_LAMBDA = "introduce.parameter.lambda";
    private TypeSelector myTypeSelector;
    private NameSuggestionsManager myNameSuggestionsManager;
    private final Project myProject;
    private final List<UsageInfo> myClassMembersList;
    private final int myOccurenceNumber;
    private final PsiMethod myMethodToSearchFor;
    private final PsiMethod myMethodToReplaceIn;
    private final boolean myMustBeFinal;
    private final PsiExpression myExpression;
    private final PsiLocalVariable myLocalVar;
    protected JCheckBox myCbDeclareFinal;
    protected JCheckBox myCbCollapseToLambda;
    private NameSuggestionsField myParameterNameField;
    private final NameSuggestionsGenerator myNameSuggestionsGenerator;
    private final TypeSelectorManager myTypeSelectorManager;
    private static final String REFACTORING_NAME = RefactoringBundle.message((String)"introduce.parameter.title");
    private NameSuggestionsField.DataChanged myParameterNameChangedListener;
    private final IntroduceParameterSettingsPanel myPanel;
    private boolean myHasWriteAccess;

    IntroduceParameterDialog(@NotNull Project project2, @NotNull List<UsageInfo> classMembersList, PsiExpression[] occurences, PsiLocalVariable onLocalVariable, PsiExpression onExpression, @NotNull NameSuggestionsGenerator generator, @NotNull TypeSelectorManager typeSelectorManager, @NotNull PsiMethod methodToSearchFor, @NotNull PsiMethod methodToReplaceIn, @NotNull TIntArrayList parametersToRemove, boolean mustBeFinal) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/refactoring/introduceParameter/IntroduceParameterDialog", "<init>"));
        }
        if (classMembersList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classMembersList", "com/intellij/refactoring/introduceParameter/IntroduceParameterDialog", "<init>"));
        }
        if (generator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generator", "com/intellij/refactoring/introduceParameter/IntroduceParameterDialog", "<init>"));
        }
        if (typeSelectorManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeSelectorManager", "com/intellij/refactoring/introduceParameter/IntroduceParameterDialog", "<init>"));
        }
        if (methodToSearchFor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodToSearchFor", "com/intellij/refactoring/introduceParameter/IntroduceParameterDialog", "<init>"));
        }
        if (methodToReplaceIn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodToReplaceIn", "com/intellij/refactoring/introduceParameter/IntroduceParameterDialog", "<init>"));
        }
        if (parametersToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parametersToRemove", "com/intellij/refactoring/introduceParameter/IntroduceParameterDialog", "<init>"));
        }
        super(project2, true);
        this.myPanel = new IntroduceParameterSettingsPanel(onLocalVariable, onExpression, methodToReplaceIn, parametersToRemove);
        this.myProject = project2;
        this.myClassMembersList = classMembersList;
        this.myOccurenceNumber = occurences.length;
        for (PsiExpression occurence : occurences) {
            if (!PsiUtil.isAccessedForWriting((PsiExpression)occurence)) continue;
            this.myHasWriteAccess = true;
            break;
        }
        this.myExpression = onExpression;
        this.myLocalVar = onLocalVariable;
        this.myMethodToReplaceIn = methodToReplaceIn;
        this.myMustBeFinal = mustBeFinal;
        this.myMethodToSearchFor = methodToSearchFor;
        this.myNameSuggestionsGenerator = generator;
        this.myTypeSelectorManager = typeSelectorManager;
        this.setTitle(REFACTORING_NAME);
        this.init();
        this.myPanel.updateTypeSelector();
    }

    protected void dispose() {
        this.myParameterNameField.removeDataChangedListener(this.myParameterNameChangedListener);
        super.dispose();
    }

    private boolean isDeclareFinal() {
        return this.myCbDeclareFinal != null && this.myCbDeclareFinal.isSelected();
    }

    private String getParameterName() {
        return this.myParameterNameField.getEnteredName().trim();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myParameterNameField.getFocusableComponent();
    }

    private PsiType getSelectedType() {
        return this.myTypeSelector.getSelectedType();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("refactoring.introduceParameter");
    }

    protected JComponent createNorthPanel() {
        GridBagConstraints gbConstraints = new GridBagConstraints();
        JPanel panel = new JPanel(new GridBagLayout());
        gbConstraints.anchor = 17;
        gbConstraints.fill = 0;
        gbConstraints.gridx = 0;
        gbConstraints.insets = JBUI.insets((int)4, (int)4, (int)4, (int)0);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.weighty = 0.0;
        gbConstraints.gridy = 0;
        JLabel type = new JLabel(RefactoringBundle.message((String)"parameter.of.type"));
        panel.add((Component)type, gbConstraints);
        gbConstraints.insets = JBUI.insets((int)4, (int)4, (int)4, (int)8);
        ++gbConstraints.gridx;
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        this.myTypeSelector = this.myTypeSelectorManager.getTypeSelector();
        panel.add((Component)this.myTypeSelector.getComponent(), gbConstraints);
        gbConstraints.insets = JBUI.insets((int)4, (int)4, (int)4, (int)8);
        gbConstraints.gridwidth = 1;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 1;
        gbConstraints.fill = 0;
        this.myParameterNameField = new NameSuggestionsField(this.myProject);
        JLabel nameLabel = new JLabel(RefactoringBundle.message((String)"name.prompt"));
        nameLabel.setLabelFor(this.myParameterNameField.getComponent());
        panel.add((Component)nameLabel, gbConstraints);
        ++gbConstraints.gridx;
        gbConstraints.insets = JBUI.insets((int)4, (int)4, (int)4, (int)8);
        gbConstraints.weightx = 1.0;
        gbConstraints.fill = 1;
        panel.add((Component)this.myParameterNameField.getComponent(), gbConstraints);
        this.myParameterNameChangedListener = new NameSuggestionsField.DataChanged(){

            @Override
            public void dataChanged() {
                IntroduceParameterDialog.this.validateButtons();
            }
        };
        this.myParameterNameField.addDataChangedListener(this.myParameterNameChangedListener);
        this.myNameSuggestionsManager = new NameSuggestionsManager(this.myTypeSelector, this.myParameterNameField, this.myNameSuggestionsGenerator);
        this.myNameSuggestionsManager.setLabelsFor(type, nameLabel);
        gbConstraints.gridx = 0;
        gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)4, (int)8);
        gbConstraints.gridwidth = 2;
        if (this.myOccurenceNumber > 1 && !this.myPanel.myIsInvokedOnDeclaration) {
            ++gbConstraints.gridy;
            this.myPanel.createOccurrencesCb(gbConstraints, panel, this.myOccurenceNumber);
        }
        if (this.myPanel.myCbReplaceAllOccurences != null) {
            gbConstraints.insets = JBUI.insets((int)0, (int)16, (int)4, (int)8);
        }
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        this.myPanel.createLocalVariablePanel(gbConstraints, panel, settings);
        this.myPanel.createRemoveParamsPanel(gbConstraints, panel);
        gbConstraints.insets = JBUI.insets((int)4, (int)0, (int)4, (int)8);
        ++gbConstraints.gridy;
        this.myCbDeclareFinal = new NonFocusableCheckBox(RefactoringBundle.message((String)"declare.final"));
        Boolean settingsFinals = settings.INTRODUCE_PARAMETER_CREATE_FINALS;
        this.myCbDeclareFinal.setSelected(settingsFinals == null ? CodeStyleSettingsManager.getSettings((Project)this.myProject).GENERATE_FINAL_PARAMETERS : settingsFinals);
        panel.add((Component)this.myCbDeclareFinal, gbConstraints);
        if (this.myMustBeFinal) {
            this.myCbDeclareFinal.setSelected(true);
            this.myCbDeclareFinal.setEnabled(false);
        } else if (this.myHasWriteAccess && this.myPanel.isReplaceAllOccurences()) {
            this.myCbDeclareFinal.setSelected(false);
            this.myCbDeclareFinal.setEnabled(false);
        }
        ++gbConstraints.gridy;
        this.myPanel.createDelegateCb(gbConstraints, panel);
        this.myCbCollapseToLambda = new NonFocusableCheckBox(RefactoringBundle.message((String)"introduce.parameter.convert.lambda"));
        PsiAnonymousClass anonymClass = this.myExpression instanceof PsiNewExpression ? ((PsiNewExpression)this.myExpression).getAnonymousClass() : null;
        this.myCbCollapseToLambda.setVisible(anonymClass != null && AnonymousCanBeLambdaInspection.canBeConvertedToLambda(anonymClass, false, Collections.emptySet()));
        this.myCbCollapseToLambda.setSelected(PropertiesComponent.getInstance((Project)this.myProject).getBoolean(INTRODUCE_PARAMETER_LAMBDA));
        ++gbConstraints.gridy;
        panel.add((Component)this.myCbCollapseToLambda, gbConstraints);
        return panel;
    }

    protected JComponent createCenterPanel() {
        if (Util.anyFieldsWithGettersPresent(this.myClassMembersList)) {
            return this.myPanel.createReplaceFieldsWithGettersPanel();
        }
        return null;
    }

    @Override
    protected void doAction() {
        PsiExpression lambda2;
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        settings.INTRODUCE_PARAMETER_REPLACE_FIELDS_WITH_GETTERS = this.myPanel.getReplaceFieldsWithGetters();
        if (this.myCbDeclareFinal != null && this.myCbDeclareFinal.isEnabled()) {
            settings.INTRODUCE_PARAMETER_CREATE_FINALS = this.myCbDeclareFinal.isSelected();
        }
        if (this.myCbCollapseToLambda.isVisible()) {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(INTRODUCE_PARAMETER_LAMBDA, this.myCbCollapseToLambda.isSelected());
        }
        this.myPanel.saveSettings(settings);
        this.myNameSuggestionsManager.nameSelected();
        boolean isDeleteLocalVariable = false;
        PsiExpression parameterInitializer = this.myExpression;
        if (this.myLocalVar != null) {
            if (this.myPanel.isUseInitializer()) {
                parameterInitializer = this.myLocalVar.getInitializer();
            }
            isDeleteLocalVariable = this.myPanel.isDeleteLocalVariable();
        }
        PsiType selectedType = this.getSelectedType();
        IntroduceParameterProcessor processor2 = new IntroduceParameterProcessor(this.myProject, this.myMethodToReplaceIn, this.myMethodToSearchFor, parameterInitializer, this.myExpression, this.myLocalVar, isDeleteLocalVariable, this.getParameterName(), this.myPanel.isReplaceAllOccurences(), this.myPanel.getReplaceFieldsWithGetters(), this.isDeclareFinal(), this.myPanel.isGenerateDelegate(), selectedType, this.myPanel.getParametersToRemove());
        if (this.myCbCollapseToLambda.isVisible() && this.myCbCollapseToLambda.isSelected() && parameterInitializer != null && (lambda2 = AnonymousCanBeLambdaInspection.replaceAnonymousWithLambda((PsiElement)parameterInitializer, selectedType)) != null) {
            PsiParameter[] lambdaParameters = ((PsiLambdaExpression)lambda2).getParameterList().getParameters();
            String methodReferenceText = LambdaCanBeMethodReferenceInspection.convertToMethodReference(((PsiLambdaExpression)lambda2).getBody(), lambdaParameters, selectedType, null);
            if (methodReferenceText != null) {
                lambda2 = JavaPsiFacade.getElementFactory((Project)this.getProject()).createExpressionFromText(methodReferenceText, (PsiElement)lambda2);
            }
            processor2.setParameterInitializer(lambda2);
        }
        this.invokeRefactoring(processor2);
    }

    private void updateFinalState() {
        if (this.myHasWriteAccess && this.myCbDeclareFinal != null) {
            this.myCbDeclareFinal.setEnabled(!this.myPanel.isReplaceAllOccurences());
            if (this.myPanel.isReplaceAllOccurences()) {
                this.myCbDeclareFinal.setSelected(false);
            }
        }
    }

    @Override
    protected void canRun() throws ConfigurationException {
        String name = this.getParameterName();
        if (name == null || !PsiNameHelper.getInstance((Project)this.myProject).isIdentifier(name)) {
            throw new ConfigurationException("'" + (name != null ? name : "") + "' is invalid parameter name");
        }
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        this.myPanel.setReplaceAllOccurrences(replaceAllOccurrences);
    }

    public void setGenerateDelegate(boolean delegate) {
        this.myPanel.setGenerateDelegate(delegate);
    }

    private class IntroduceParameterSettingsPanel
    extends IntroduceParameterSettingsUI {
        public IntroduceParameterSettingsPanel(PsiLocalVariable onLocalVariable, PsiExpression onExpression, PsiMethod methodToReplaceIn, TIntArrayList parametersToRemove) {
            super(onLocalVariable, onExpression, methodToReplaceIn, parametersToRemove);
        }

        @Override
        protected TypeSelectorManager getTypeSelectionManager() {
            return IntroduceParameterDialog.this.myTypeSelectorManager;
        }

        @Override
        protected void updateControls(JCheckBox[] removeParamsCb) {
            super.updateControls(removeParamsCb);
            IntroduceParameterDialog.this.updateFinalState();
        }

        public void setGenerateDelegate(boolean delegate) {
            this.myCbGenerateDelegate.setSelected(delegate);
        }
    }
}

