/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.ui.components.JBList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NonNls;

abstract class RenameChooser {
    @NonNls
    private static final String CODE_OCCURRENCES = "Rename code occurrences";
    @NonNls
    private static final String ALL_OCCURRENCES = "Rename all occurrences";
    private final Set<RangeHighlighter> myRangeHighlighters = new HashSet<RangeHighlighter>();
    private final Editor myEditor;
    private final TextAttributes myAttributes;

    public RenameChooser(Editor editor) {
        this.myEditor = editor;
        this.myAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
    }

    protected abstract void runRenameTemplate(Collection<Pair<PsiElement, TextRange>> var1);

    public void showChooser(Collection<PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.runRenameTemplate(RefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_FILE ? stringUsages : new ArrayList());
            return;
        }
        DefaultListModel<String> model = new DefaultListModel<String>();
        model.addElement(CODE_OCCURRENCES);
        model.addElement(ALL_OCCURRENCES);
        JBList list = new JBList(model);
        list.addListSelectionListener(new ListSelectionListener((JList)list, stringUsages, refs){
            final /* synthetic */ JList val$list;
            final /* synthetic */ Collection val$stringUsages;
            final /* synthetic */ Collection val$refs;
            {
                this.val$list = jList;
                this.val$stringUsages = collection;
                this.val$refs = collection2;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String selectedValue = (String)this.val$list.getSelectedValue();
                if (selectedValue == null) {
                    return;
                }
                RenameChooser.this.dropHighlighters();
                MarkupModel markupModel = RenameChooser.this.myEditor.getMarkupModel();
                if (selectedValue.equals(RenameChooser.ALL_OCCURRENCES)) {
                    for (Pair pair : this.val$stringUsages) {
                        TextRange textRange = ((TextRange)pair.second).shiftRight(((PsiElement)pair.first).getTextOffset());
                        RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, RenameChooser.this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                        RenameChooser.this.myRangeHighlighters.add(rangeHighlighter);
                    }
                }
                for (PsiReference reference : this.val$refs) {
                    PsiElement element = reference.getElement();
                    if (element == null) continue;
                    TextRange textRange = element.getTextRange();
                    RangeHighlighter rangeHighlighter = markupModel.addRangeHighlighter(textRange.getStartOffset(), textRange.getEndOffset(), 5999, RenameChooser.this.myAttributes, HighlighterTargetArea.EXACT_RANGE);
                    RenameChooser.this.myRangeHighlighters.add(rangeHighlighter);
                }
            }
        });
        JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setTitle("String occurrences found").setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> this.lambda$showChooser$0((JList)list, stringUsages)).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                RenameChooser.this.dropHighlighters();
            }
        }).createPopup().showInBestPositionFor(this.myEditor);
    }

    private void dropHighlighters() {
        for (RangeHighlighter highlight : this.myRangeHighlighters) {
            highlight.dispose();
        }
        this.myRangeHighlighters.clear();
    }

    private /* synthetic */ void lambda$showChooser$0(JList list, Collection stringUsages) {
        this.runRenameTemplate(ALL_OCCURRENCES.equals(list.getSelectedValue()) ? stringUsages : new ArrayList());
    }
}

