/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.safeDelete.ImportSearcher;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteDelegate;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.OverridingMethodsDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.refactoring.safeDelete.SafeDeleteJavaCalleeChooser;
import com.intellij.refactoring.safeDelete.SafeDeleteJavaCallerChooser;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteAnnotation;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteExtendsClassUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteFieldWriteReference;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteMethodCalleeUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteOverrideAnnotation;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteOverridingMethodUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteParameterCallHierarchyUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeletePrivatizeMethod;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSafeDeleteProcessor
extends SafeDeleteProcessorDelegateBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.safeDelete.JavaSafeDeleteProcessor");

    @Override
    public boolean handlesElement(PsiElement element) {
        return element instanceof PsiClass || element instanceof PsiMethod || element instanceof PsiField || element instanceof PsiParameter || element instanceof PsiLocalVariable || element instanceof PsiPackage;
    }

    @Override
    @Nullable
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete, @NotNull List<UsageInfo> usages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor", "findUsages"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor", "findUsages"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor", "findUsages"));
        }
        Condition<PsiElement> insideDeletedCondition = JavaSafeDeleteProcessor.getUsageInsideDeletedFilter(allElementsToDelete);
        if (element instanceof PsiClass) {
            JavaSafeDeleteProcessor.findClassUsages((PsiClass)element, allElementsToDelete, usages);
            if (element instanceof PsiTypeParameter) {
                JavaSafeDeleteProcessor.findTypeParameterExternalUsages((PsiTypeParameter)element, usages);
            }
        } else if (element instanceof PsiMethod) {
            insideDeletedCondition = JavaSafeDeleteProcessor.findMethodUsages((PsiMethod)element, allElementsToDelete, usages);
        } else if (element instanceof PsiField) {
            insideDeletedCondition = JavaSafeDeleteProcessor.findFieldUsages((PsiField)element, usages, allElementsToDelete);
        } else if (element instanceof PsiParameter) {
            LOG.assertTrue(((PsiParameter)element).getDeclarationScope() instanceof PsiMethod);
            JavaSafeDeleteProcessor.findParameterUsages((PsiParameter)element, usages);
        } else if (element instanceof PsiLocalVariable) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)element)) {
                PsiReferenceExpression referencedElement = (PsiReferenceExpression)reference.getElement();
                PsiStatement statement2 = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)referencedElement, PsiStatement.class);
                boolean isSafeToDelete = PsiUtil.isAccessedForWriting((PsiExpression)referencedElement);
                boolean hasSideEffects = false;
                if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)referencedElement)) {
                    hasSideEffects = RemoveUnusedVariableUtil.checkSideEffects(((PsiAssignmentExpression)referencedElement.getParent()).getRExpression(), (PsiVariable)((PsiLocalVariable)element), new ArrayList<PsiElement>());
                }
                usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)statement2, element, isSafeToDelete && !hasSideEffects));
            }
        }
        return new NonCodeUsageSearchInfo(insideDeletedCondition, element);
    }

    @Override
    @Nullable
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @Nullable Module module2, @NotNull Collection<PsiElement> allElementsToDelete) {
        int index;
        PsiTypeParameterList typeParameterList;
        PsiTypeParameterListOwner owner;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor", "getElementsToSearch"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor", "getElementsToSearch"));
        }
        Project project2 = element.getProject();
        if (element instanceof PsiPackage && module2 != null) {
            PsiDirectory[] directories = ((PsiPackage)element).getDirectories(module2.getModuleScope());
            if (directories.length == 0) {
                return null;
            }
            return Arrays.asList(directories);
        }
        if (element instanceof PsiMethod) {
            PsiMethod[] methods = SuperMethodWarningUtil.checkSuperMethods((PsiMethod)element, RefactoringBundle.message((String)"to.delete.with.usage.search"), allElementsToDelete);
            if (methods.length == 0) {
                return null;
            }
            ArrayList<PsiMethod> psiMethods = new ArrayList<PsiMethod>(Arrays.asList(methods));
            psiMethods.add((PsiMethod)element);
            return psiMethods;
        }
        if (element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)((PsiParameter)element).getDeclarationScope();
            HashSet<PsiParameter> parametersToDelete = new HashSet<PsiParameter>();
            parametersToDelete.add((PsiParameter)element);
            int parameterIndex = method.getParameterList().getParameterIndex((PsiParameter)element);
            ArrayList<PsiMethod> superMethods = new ArrayList<PsiMethod>(Arrays.asList(method.findDeepestSuperMethods()));
            if (superMethods.isEmpty()) {
                superMethods.add(method);
            }
            for (PsiMethod superMethod : superMethods) {
                parametersToDelete.add(superMethod.getParameterList().getParameters()[parameterIndex]);
                OverridingMethodsSearch.search((PsiMethod)superMethod).forEach(overrider -> {
                    parametersToDelete.add(overrider.getParameterList().getParameters()[parameterIndex]);
                    return true;
                });
            }
            if (parametersToDelete.size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                String message = RefactoringBundle.message((String)"0.is.a.part.of.method.hierarchy.do.you.want.to.delete.multiple.parameters", (Object[])new Object[]{UsageViewUtil.getLongName((PsiElement)method)});
                int result2 = Messages.showYesNoCancelDialog((Project)project2, (String)message, (String)SafeDeleteHandler.REFACTORING_NAME, (Icon)Messages.getQuestionIcon());
                if (result2 == 2) {
                    return null;
                }
                if (result2 == 1) {
                    return Collections.singletonList(element);
                }
            }
            return parametersToDelete;
        }
        if (element instanceof PsiTypeParameter && (owner = ((PsiTypeParameter)element).getOwner()) instanceof PsiMethod && !owner.hasModifierProperty("static") && (typeParameterList = owner.getTypeParameterList()) != null && (index = typeParameterList.getTypeParameterIndex((PsiTypeParameter)element)) >= 0) {
            ArrayList<PsiTypeParameter> overriders = new ArrayList<PsiTypeParameter>();
            overriders.add((PsiTypeParameter)element);
            OverridingMethodsSearch.search((PsiMethod)((PsiMethod)owner)).forEach(overrider -> {
                PsiTypeParameter[] typeParameters = overrider.getTypeParameters();
                if (index < typeParameters.length) {
                    overriders.add(typeParameters[index]);
                }
                return true;
            });
            if (overriders.size() > 1) {
                int result3;
                String message = RefactoringBundle.message((String)"0.is.a.part.of.method.hierarchy.do.you.want.to.delete.multiple.type.parameters", (Object[])new Object[]{UsageViewUtil.getLongName((PsiElement)owner)});
                int n = result3 = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((Project)project2, (String)message, (String)SafeDeleteHandler.REFACTORING_NAME, (Icon)Messages.getQuestionIcon());
                if (result3 == 2) {
                    return null;
                }
                if (result3 == 0) {
                    return overriders;
                }
            }
        }
        return Collections.singletonList(element);
    }

    @Override
    public UsageView showUsages(UsageInfo[] usages, UsageViewPresentation presentation, UsageViewManager manager, PsiElement[] elements) {
        ArrayList<PsiMethod> overridingMethods = new ArrayList<PsiMethod>();
        ArrayList<UsageInfo> others = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage instanceof SafeDeleteOverridingMethodUsageInfo) {
                overridingMethods.add(((SafeDeleteOverridingMethodUsageInfo)usage).getOverridingMethod());
                continue;
            }
            others.add(usage);
        }
        UsageTarget[] targets = new UsageTarget[elements.length + overridingMethods.size()];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = i < elements.length ? new PsiElement2UsageTargetAdapter(elements[i]) : new PsiElement2UsageTargetAdapter((PsiElement)overridingMethods.get(i - elements.length));
        }
        return manager.showUsages(targets, UsageInfoToUsageConverter.convert((PsiElement[])elements, (UsageInfo[])others.toArray(new UsageInfo[others.size()])), presentation);
    }

    @Override
    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<PsiElement> allElementsToDelete, boolean askUser) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor", "getAdditionalElementsToDelete"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor", "getAdditionalElementsToDelete"));
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            Project project2 = element.getProject();
            String propertyName = JavaCodeStyleManager.getInstance((Project)project2).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
            PsiClass aClass = field.getContainingClass();
            if (aClass != null) {
                PsiMethod setter;
                boolean isStatic = field.hasModifierProperty("static");
                PsiMethod[] getters = GetterSetterPrototypeProvider.findGetters(aClass, propertyName, isStatic);
                if (getters != null) {
                    ArrayList<PsiMethod> validGetters = new ArrayList<PsiMethod>(1);
                    for (PsiMethod getter : getters) {
                        if (allElementsToDelete.contains(getter) || getter == null || !getter.isPhysical()) continue;
                        validGetters.add(getter);
                    }
                    PsiMethod[] psiMethodArray = getters = validGetters.isEmpty() ? null : validGetters.toArray(new PsiMethod[validGetters.size()]);
                }
                if (allElementsToDelete.contains(setter = PropertyUtil.findPropertySetter((PsiClass)aClass, (String)propertyName, (boolean)isStatic, (boolean)false)) || setter != null && !setter.isPhysical()) {
                    setter = null;
                }
                if (askUser && (getters != null || setter != null)) {
                    String message = RefactoringMessageUtil.getGetterSetterMessage(field.getName(), RefactoringBundle.message((String)"delete.title"), getters != null ? getters[0] : null, setter);
                    if (!ApplicationManager.getApplication().isUnitTestMode() && Messages.showYesNoDialog((Project)project2, (String)message, (String)RefactoringBundle.message((String)"safe.delete.title"), (Icon)Messages.getQuestionIcon()) != 0) {
                        getters = null;
                        setter = null;
                    }
                }
                ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                if (setter != null) {
                    elements.add((PsiElement)setter);
                }
                if (getters != null) {
                    Collections.addAll(elements, getters);
                }
                return elements;
            }
        }
        return null;
    }

    @Override
    public Collection<String> findConflicts(PsiElement element, PsiElement[] elements, UsageInfo[] usages) {
        String methodRefFound = null;
        if (!ApplicationManager.getApplication().isUnitTestMode() && (element instanceof PsiMethod || element instanceof PsiParameter)) {
            for (UsageInfo usage : usages) {
                PsiElement refElement = usage.getElement();
                if (!(refElement instanceof PsiMethodReferenceExpression)) continue;
                methodRefFound = RefactoringBundle.message((String)"expand.method.reference.warning");
                break;
            }
        }
        if (methodRefFound != null) {
            ArrayList<String> result2 = new ArrayList<String>();
            result2.add(methodRefFound);
            Collection<String> conflicts = super.findConflicts(element, elements, usages);
            if (conflicts != null) {
                result2.addAll(conflicts);
            }
            return result2;
        }
        return super.findConflicts(element, elements, usages);
    }

    @Override
    public Collection<String> findConflicts(@NotNull PsiElement element, @NotNull PsiElement[] allElementsToDelete) {
        PsiMethod method;
        PsiClass containingClass;
        PsiElement scope;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor", "findConflicts"));
        }
        if (allElementsToDelete == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allElementsToDelete", "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor", "findConflicts"));
        }
        if (element instanceof PsiMethod) {
            PsiClass containingClass2 = ((PsiMethod)element).getContainingClass();
            if (containingClass2 != null && !containingClass2.hasModifierProperty("abstract")) {
                PsiMethod[] superMethods;
                for (PsiMethod superMethod : superMethods = ((PsiMethod)element).findSuperMethods()) {
                    if (JavaSafeDeleteProcessor.isInside((PsiElement)superMethod, allElementsToDelete) || !superMethod.hasModifierProperty("abstract")) continue;
                    String message = RefactoringBundle.message((String)"0.implements.1", (Object[])new Object[]{RefactoringUIUtil.getDescription(element, true), RefactoringUIUtil.getDescription((PsiElement)superMethod, true)});
                    return Collections.singletonList(message);
                }
            }
        } else if (element instanceof PsiParameter && (scope = ((PsiParameter)element).getDeclarationScope()) instanceof PsiMethod && (containingClass = (method = (PsiMethod)scope).getContainingClass()) != null) {
            int parameterIndex = method.getParameterList().getParameterIndex((PsiParameter)element);
            PsiMethod methodCopy = (PsiMethod)method.copy();
            methodCopy.getParameterList().getParameters()[parameterIndex].delete();
            MultiMap conflicts = new MultiMap();
            ConflictsUtil.checkMethodConflicts(containingClass, method, methodCopy, (MultiMap<PsiElement, String>)conflicts);
            return conflicts.values();
        }
        return null;
    }

    @Override
    @Nullable
    public UsageInfo[] preprocessUsages(Project project2, UsageInfo[] usages) {
        ArrayList<UsageInfo> result2 = new ArrayList<UsageInfo>();
        ArrayList<UsageInfo> overridingMethods = new ArrayList<UsageInfo>();
        final ArrayList<SafeDeleteParameterCallHierarchyUsageInfo> delegatingParams = new ArrayList<SafeDeleteParameterCallHierarchyUsageInfo>();
        final ArrayList<SafeDeleteMethodCalleeUsageInfo> calleesSafeToDelete = new ArrayList<SafeDeleteMethodCalleeUsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage.isNonCodeUsage) {
                result2.add(usage);
                continue;
            }
            if (usage instanceof SafeDeleteMethodCalleeUsageInfo) {
                calleesSafeToDelete.add((SafeDeleteMethodCalleeUsageInfo)usage);
                continue;
            }
            if (usage instanceof SafeDeleteOverridingMethodUsageInfo) {
                overridingMethods.add(usage);
                continue;
            }
            if (usage instanceof SafeDeleteParameterCallHierarchyUsageInfo) {
                delegatingParams.add((SafeDeleteParameterCallHierarchyUsageInfo)usage);
                continue;
            }
            if (usage instanceof SafeDeleteAnnotation) {
                result2.add(new SafeDeleteAnnotation((PsiAnnotation)usage.getElement(), ((SafeDeleteAnnotation)usage).getReferencedElement(), true));
                continue;
            }
            result2.add(usage);
        }
        if (!overridingMethods.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                result2.addAll(overridingMethods);
            } else {
                OverridingMethodsDialog dialog = new OverridingMethodsDialog(project2, overridingMethods);
                if (!dialog.showAndGet()) {
                    return null;
                }
                ArrayList<UsageInfo> selected = dialog.getSelected();
                HashSet<UsageInfo> unselected = new HashSet<UsageInfo>(overridingMethods);
                unselected.removeAll(selected);
                if (!unselected.isEmpty()) {
                    List unselectedMethods = ContainerUtil.map(unselected, info -> ((SafeDeleteOverridingMethodUsageInfo)info).getOverridingMethod());
                    Iterator iterator = result2.iterator();
                    while (iterator.hasNext()) {
                        UsageInfo info2 = (UsageInfo)iterator.next();
                        if (!(info2 instanceof SafeDeleteOverrideAnnotation) || JavaSafeDeleteProcessor.allSuperMethodsSelectedToDelete(unselectedMethods, ((SafeDeleteOverrideAnnotation)info2).getMethod())) continue;
                        iterator.remove();
                    }
                }
                result2.addAll(selected);
            }
        }
        if (!delegatingParams.isEmpty()) {
            SafeDeleteParameterCallHierarchyUsageInfo parameterHierarchyUsageInfo = (SafeDeleteParameterCallHierarchyUsageInfo)delegatingParams.get(0);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                result2.addAll(delegatingParams);
            } else {
                PsiMethod method = parameterHierarchyUsageInfo.getCalledMethod();
                PsiParameter parameter = parameterHierarchyUsageInfo.getReferencedElement();
                final int parameterIndex = method.getParameterList().getParameterIndex(parameter);
                SafeDeleteJavaCallerChooser chooser = new SafeDeleteJavaCallerChooser(method, project2, result2){

                    @Override
                    protected ArrayList<SafeDeleteParameterCallHierarchyUsageInfo> getTopLevelItems() {
                        return delegatingParams;
                    }

                    @Override
                    protected int getParameterIdx() {
                        return parameterIndex;
                    }
                };
                TreeUtil.expand((JTree)chooser.getTree(), (int)2);
                if (!chooser.showAndGet()) {
                    return null;
                }
            }
        }
        if (!calleesSafeToDelete.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                result2.addAll(calleesSafeToDelete);
            } else {
                PsiMethod method = ((SafeDeleteMethodCalleeUsageInfo)calleesSafeToDelete.get(0)).getCallerMethod();
                ArrayList list = new ArrayList();
                SafeDeleteJavaCalleeChooser chooser = new SafeDeleteJavaCalleeChooser(method, project2, list){

                    @Override
                    protected ArrayList<SafeDeleteMethodCalleeUsageInfo> getTopLevelItems() {
                        return calleesSafeToDelete;
                    }
                };
                TreeUtil.expand((JTree)chooser.getTree(), (int)2);
                if (!chooser.showAndGet()) {
                    return null;
                }
                result2.addAll(list);
                ArrayList<Object> methodsToDelete = new ArrayList<Object>();
                for (UsageInfo info2 : list) {
                    methodsToDelete.add(info2.getElement());
                }
                methodsToDelete.add(method);
                Condition<PsiElement> insideDeletedCondition = JavaSafeDeleteProcessor.getUsageInsideDeletedFilter(methodsToDelete.toArray(new PsiElement[methodsToDelete.size()]));
                for (UsageInfo info3 : list) {
                    SafeDeleteProcessor.addNonCodeUsages(info3.getElement(), result2, insideDeletedCondition, JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD, JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD);
                }
            }
        }
        return result2.toArray(new UsageInfo[result2.size()]);
    }

    private static boolean allSuperMethodsSelectedToDelete(List<PsiMethod> unselectedMethods, PsiMethod method) {
        ArrayList<PsiMethod> superMethods = new ArrayList<PsiMethod>(Arrays.asList(method.findSuperMethods()));
        superMethods.retainAll(unselectedMethods);
        return superMethods.isEmpty();
    }

    @Override
    public void prepareForDeletion(PsiElement element) throws IncorrectOperationException {
        if (element instanceof PsiVariable) {
            ((PsiVariable)element).normalizeDeclaration();
        }
    }

    @Override
    public boolean isToSearchInComments(PsiElement element) {
        if (element instanceof PsiClass) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS;
        }
        if (element instanceof PsiMethod) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD;
        }
        if (element instanceof PsiVariable) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE;
        }
        if (element instanceof PsiPackage) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE;
        }
        return false;
    }

    @Override
    public void setToSearchInComments(PsiElement element, boolean enabled) {
        if (element instanceof PsiClass) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS = enabled;
        } else if (element instanceof PsiMethod) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD = enabled;
        } else if (element instanceof PsiVariable) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE = enabled;
        } else if (element instanceof PsiPackage) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE = enabled;
        }
    }

    @Override
    public boolean isToSearchForTextOccurrences(PsiElement element) {
        if (element instanceof PsiClass) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS;
        }
        if (element instanceof PsiMethod) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD;
        }
        if (element instanceof PsiVariable) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE;
        }
        if (element instanceof PsiPackage) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE;
        }
        return false;
    }

    @Override
    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        if (element instanceof PsiClass) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS = enabled;
        } else if (element instanceof PsiMethod) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD = enabled;
        } else if (element instanceof PsiVariable) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE = enabled;
        } else if (element instanceof PsiPackage) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE = enabled;
        }
    }

    public static Condition<PsiElement> getUsageInsideDeletedFilter(PsiElement[] allElementsToDelete) {
        return usage -> !(usage instanceof PsiFile) && JavaSafeDeleteProcessor.isInside(usage, allElementsToDelete);
    }

    private static void findClassUsages(PsiClass psiClass, PsiElement[] allElementsToDelete, List<UsageInfo> usages) {
        boolean justPrivates = JavaSafeDeleteProcessor.containsOnlyPrivates(psiClass);
        String qualifiedName = psiClass.getQualifiedName();
        boolean annotationType = psiClass.isAnnotationType() && qualifiedName != null;
        ReferencesSearch.search((PsiElement)psiClass).forEach(reference -> {
            PsiElement element = reference.getElement();
            if (!JavaSafeDeleteProcessor.isInside(element, allElementsToDelete)) {
                boolean safeDelete;
                PsiElement pparent;
                PsiElement parent = element.getParent();
                if (parent instanceof PsiReferenceList && (pparent = parent.getParent()) instanceof PsiClass && element instanceof PsiJavaCodeReferenceElement) {
                    PsiClass inheritor = (PsiClass)pparent;
                    if (justPrivates && (parent.equals(inheritor.getExtendsList()) || parent.equals(inheritor.getImplementsList()))) {
                        usages.add(new SafeDeleteExtendsClassUsageInfo((PsiJavaCodeReferenceElement)element, psiClass, inheritor));
                        return true;
                    }
                }
                LOG.assertTrue(element.getTextRange() != null);
                PsiFile containingFile = psiClass.getContainingFile();
                boolean sameFileWithSingleClass = false;
                if (containingFile instanceof PsiClassOwner) {
                    PsiClass[] classes = ((PsiClassOwner)containingFile).getClasses();
                    sameFileWithSingleClass = classes.length == 1 && classes[0] == psiClass && element.getContainingFile() == containingFile;
                }
                boolean bl = safeDelete = sameFileWithSingleClass || JavaSafeDeleteProcessor.isInNonStaticImport(element);
                if (annotationType && parent instanceof PsiAnnotation) {
                    usages.add(new SafeDeleteAnnotation((PsiAnnotation)parent, (PsiElement)psiClass, safeDelete));
                } else {
                    usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)psiClass, safeDelete));
                }
            }
            return true;
        });
    }

    private static boolean isInNonStaticImport(PsiElement element) {
        return ImportSearcher.getImport(element, true) != null;
    }

    private static boolean containsOnlyPrivates(PsiClass aClass) {
        PsiClass[] inners;
        PsiMethod[] methods;
        PsiField[] fields;
        for (PsiField field : fields = aClass.getFields()) {
            if (field.hasModifierProperty("private")) continue;
            return false;
        }
        for (PsiMethod method : methods = aClass.getMethods()) {
            PsiReferenceExpression methodExpression;
            PsiExpression expression;
            PsiStatement[] statements;
            PsiCodeBlock body;
            if (method.hasModifierProperty("private") || method.isConstructor() && (body = method.getBody()) != null && ((statements = body.getStatements()).length == 0 || statements.length == 1 && statements[0] instanceof PsiExpressionStatement && (expression = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && (methodExpression = ((PsiMethodCallExpression)expression).getMethodExpression()).getText().equals("super"))) continue;
            return false;
        }
        for (PsiClass inner : inners = aClass.getInnerClasses()) {
            if (inner.hasModifierProperty("private")) continue;
            return false;
        }
        return true;
    }

    private static void findTypeParameterExternalUsages(PsiTypeParameter typeParameter, Collection<UsageInfo> usages) {
        PsiTypeParameterList parameterList;
        PsiTypeParameterListOwner owner = typeParameter.getOwner();
        if (owner != null && (parameterList = owner.getTypeParameterList()) != null) {
            int paramsCount = parameterList.getTypeParameters().length;
            int index = parameterList.getTypeParameterIndex(typeParameter);
            ReferencesSearch.search((PsiElement)owner).forEach(reference -> {
                PsiTypeElement[] typeArgs;
                PsiReferenceParameterList parameterList1;
                if (reference instanceof PsiJavaCodeReferenceElement && (parameterList1 = ((PsiJavaCodeReferenceElement)reference).getParameterList()) != null && (typeArgs = parameterList1.getTypeParameterElements()).length > index) {
                    if (typeArgs.length == 1 && paramsCount > 1 && typeArgs[0].getType() instanceof PsiDiamondType) {
                        return true;
                    }
                    usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)typeArgs[index], (PsiElement)typeParameter, true));
                }
                return true;
            });
        }
    }

    @Nullable
    private static Condition<PsiElement> findMethodUsages(PsiMethod psiMethod, PsiElement[] allElementsToDelete, List<UsageInfo> usages) {
        Collection references = ReferencesSearch.search((PsiElement)psiMethod).findAll();
        if (psiMethod.isConstructor()) {
            return JavaSafeDeleteProcessor.findConstructorUsages(psiMethod, references, usages, allElementsToDelete);
        }
        Object[] overridingMethods = JavaSafeDeleteProcessor.removeDeletedMethods((PsiMethod[])OverridingMethodsSearch.search((PsiMethod)psiMethod).toArray((Object[])PsiMethod.EMPTY_ARRAY), allElementsToDelete);
        JavaSafeDeleteProcessor.findFunctionalExpressions(usages, (PsiMethod[])ArrayUtil.prepend((Object)psiMethod, (Object[])overridingMethods));
        HashMap methodToReferences = new HashMap();
        for (Object overridingMethod : overridingMethods) {
            Collection overridingReferences = ReferencesSearch.search((PsiElement)overridingMethod).findAll();
            methodToReferences.put(overridingMethod, (Object)overridingReferences);
        }
        Set<PsiMethod> validOverriding = JavaSafeDeleteProcessor.validateOverridingMethods(psiMethod, references, Arrays.asList(overridingMethods), (HashMap<PsiMethod, Collection<PsiReference>>)methodToReferences, usages, allElementsToDelete);
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, validOverriding)) continue;
            usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)psiMethod, PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class) != null));
        }
        List<PsiMethod> calleesSafeToDelete = SafeDeleteJavaCalleeChooser.computeCalleesSafeToDelete(psiMethod);
        if (calleesSafeToDelete != null) {
            for (PsiMethod method : calleesSafeToDelete) {
                usages.add(new SafeDeleteMethodCalleeUsageInfo(method, psiMethod));
            }
        }
        return usage -> {
            if (usage instanceof PsiFile) {
                return false;
            }
            return JavaSafeDeleteProcessor.isInside(usage, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(usage, validOverriding);
        };
    }

    private static void findFunctionalExpressions(List<UsageInfo> usages, PsiMethod ... methods) {
        for (PsiMethod method : methods) {
            PsiClass containingClass = method.getContainingClass();
            FunctionalExpressionSearch.search((PsiMethod)method).forEach(expression -> {
                usages.add(new SafeDeleteFunctionalExpressionUsageInfo((PsiElement)expression, (PsiElement)containingClass));
                return true;
            });
        }
    }

    private static PsiMethod[] removeDeletedMethods(PsiMethod[] methods, PsiElement[] allElementsToDelete) {
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods) {
            boolean isDeleted = false;
            for (PsiElement element : allElementsToDelete) {
                if (element != method) continue;
                isDeleted = true;
                break;
            }
            if (isDeleted) continue;
            list.add(method);
        }
        return list.toArray(new PsiMethod[list.size()]);
    }

    @Nullable
    private static Condition<PsiElement> findConstructorUsages(PsiMethod constructor, Collection<PsiReference> originalReferences, List<UsageInfo> usages, PsiElement[] allElementsToDelete) {
        HashMap constructorsToRefs = new HashMap();
        HashSet<Object> newConstructors = new HashSet<Object>();
        if (JavaSafeDeleteProcessor.isTheOnlyEmptyDefaultConstructor(constructor)) {
            return null;
        }
        newConstructors.add(constructor);
        constructorsToRefs.put((Object)constructor, originalReferences);
        HashSet<PsiMethod> passConstructors = new HashSet<PsiMethod>();
        do {
            passConstructors.clear();
            for (PsiMethod psiMethod : newConstructors) {
                Collection references = (Collection)constructorsToRefs.get((Object)psiMethod);
                for (PsiReference reference : references) {
                    PsiMethod overridingConstructor = JavaSafeDeleteProcessor.getOverridingConstructorOfSuperCall(reference.getElement());
                    if (overridingConstructor == null || constructorsToRefs.containsKey((Object)overridingConstructor)) continue;
                    Collection overridingConstructorReferences = ReferencesSearch.search((PsiElement)overridingConstructor).findAll();
                    constructorsToRefs.put((Object)overridingConstructor, (Object)overridingConstructorReferences);
                    passConstructors.add(overridingConstructor);
                }
            }
            newConstructors.clear();
            newConstructors.addAll(passConstructors);
        } while (!newConstructors.isEmpty());
        Set<PsiMethod> validOverriding = JavaSafeDeleteProcessor.validateOverridingMethods(constructor, originalReferences, constructorsToRefs.keySet(), (HashMap<PsiMethod, Collection<PsiReference>>)constructorsToRefs, usages, allElementsToDelete);
        return usage -> {
            if (usage instanceof PsiFile) {
                return false;
            }
            return JavaSafeDeleteProcessor.isInside(usage, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(usage, validOverriding);
        };
    }

    private static boolean isTheOnlyEmptyDefaultConstructor(PsiMethod constructor) {
        if (constructor.getParameterList().getParameters().length > 0) {
            return false;
        }
        PsiCodeBlock body = constructor.getBody();
        if (body != null && body.getStatements().length > 0) {
            return false;
        }
        return constructor.getContainingClass().getConstructors().length == 1;
    }

    private static Set<PsiMethod> validateOverridingMethods(PsiMethod originalMethod, Collection<PsiReference> originalReferences, Collection<PsiMethod> overridingMethods, HashMap<PsiMethod, Collection<PsiReference>> methodToReferences, List<UsageInfo> usages, PsiElement[] allElementsToDelete) {
        boolean anyNewBadRefs;
        LinkedHashSet<PsiMethod> validOverriding = new LinkedHashSet<PsiMethod>(overridingMethods);
        HashSet<PsiMethod> multipleInterfaceImplementations = new HashSet<PsiMethod>();
        do {
            anyNewBadRefs = false;
            for (PsiMethod overridingMethod : overridingMethods) {
                PsiElement element;
                if (!validOverriding.contains(overridingMethod)) continue;
                Collection overridingReferences = (Collection)methodToReferences.get((Object)overridingMethod);
                boolean anyOverridingRefs = false;
                for (PsiReference overridingReference : overridingReferences) {
                    element = overridingReference.getElement();
                    if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, validOverriding)) continue;
                    anyOverridingRefs = true;
                    break;
                }
                if (!anyOverridingRefs && JavaSafeDeleteProcessor.isMultipleInterfacesImplementation(overridingMethod, originalMethod, allElementsToDelete)) {
                    anyOverridingRefs = true;
                    multipleInterfaceImplementations.add(overridingMethod);
                }
                if (!anyOverridingRefs) continue;
                validOverriding.remove(overridingMethod);
                anyNewBadRefs = true;
                for (PsiReference reference : originalReferences) {
                    element = reference.getElement();
                    if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, overridingMethods)) continue;
                    usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)originalMethod, false));
                    validOverriding.clear();
                }
            }
        } while (anyNewBadRefs && !validOverriding.isEmpty());
        for (PsiMethod method : validOverriding) {
            if (method == originalMethod) continue;
            usages.add(new SafeDeleteOverridingMethodUsageInfo(method, originalMethod));
        }
        for (PsiMethod method : overridingMethods) {
            if (!validOverriding.contains(method) && !multipleInterfaceImplementations.contains(method) && JavaSafeDeleteProcessor.canBePrivate(method, (Collection)methodToReferences.get((Object)method), validOverriding, allElementsToDelete)) {
                usages.add(new SafeDeletePrivatizeMethod(method, originalMethod));
                continue;
            }
            usages.add(new SafeDeleteOverrideAnnotation((PsiElement)method, (PsiElement)originalMethod));
        }
        return validOverriding;
    }

    private static boolean isMultipleInterfacesImplementation(PsiMethod method, PsiMethod originalMethod, PsiElement[] allElementsToDelete) {
        PsiMethod[] methods;
        for (PsiMethod superMethod : methods = method.findSuperMethods()) {
            if (ArrayUtil.find((Object[])allElementsToDelete, (Object)superMethod) >= 0 || MethodSignatureUtil.isSuperMethod((PsiMethod)originalMethod, (PsiMethod)superMethod)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiMethod getOverridingConstructorOfSuperCall(PsiElement element) {
        PsiElement parent;
        if (element instanceof PsiReferenceExpression && "super".equals(element.getText()) && (parent = element.getParent()) instanceof PsiMethodCallExpression && (parent = parent.getParent()) instanceof PsiExpressionStatement && (parent = parent.getParent()) instanceof PsiCodeBlock && (parent = parent.getParent()) instanceof PsiMethod && ((PsiMethod)parent).isConstructor()) {
            return (PsiMethod)parent;
        }
        return null;
    }

    private static boolean canBePrivate(PsiMethod method, Collection<PsiReference> references, Collection<? extends PsiElement> deleted, PsiElement[] allElementsToDelete) {
        PsiModifierList privateModifierList;
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return false;
        }
        PsiManager manager = method.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        PsiElementFactory factory = facade.getElementFactory();
        try {
            PsiMethod newMethod = factory.createMethod("x3", (PsiType)PsiType.VOID);
            privateModifierList = newMethod.getModifierList();
            privateModifierList.setModifierProperty("private", true);
        }
        catch (IncorrectOperationException e) {
            LOG.assertTrue(false);
            return false;
        }
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, deleted) || facade.getResolveHelper().isAccessible((PsiMember)method, privateModifierList, element, null, null)) continue;
            return false;
        }
        return true;
    }

    private static Condition<PsiElement> findFieldUsages(PsiField psiField, List<UsageInfo> usages, PsiElement[] allElementsToDelete) {
        Condition<PsiElement> isInsideDeleted = JavaSafeDeleteProcessor.getUsageInsideDeletedFilter(allElementsToDelete);
        ReferencesSearch.search((PsiElement)psiField).forEach(reference -> {
            if (!isInsideDeleted.value((Object)reference.getElement())) {
                PsiElement element = reference.getElement();
                PsiElement parent = element.getParent();
                if (parent instanceof PsiAssignmentExpression && element == ((PsiAssignmentExpression)parent).getLExpression()) {
                    usages.add(new SafeDeleteFieldWriteReference((PsiAssignmentExpression)parent, psiField));
                } else {
                    TextRange range = reference.getRangeInElement();
                    usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(reference.getElement(), (PsiElement)psiField, range.getStartOffset(), range.getEndOffset(), false, PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class) != null));
                }
            }
            return true;
        });
        return isInsideDeleted;
    }

    private static void findParameterUsages(PsiParameter parameter, List<UsageInfo> usages) {
        PsiMethod method = (PsiMethod)parameter.getDeclarationScope();
        int parameterIndex = method.getParameterList().getParameterIndex(parameter);
        ReferencesSearch.search((PsiElement)method).forEach(reference -> {
            PsiElement element = reference.getElement();
            if (element != null) {
                PsiParameter paramInCaller;
                JavaSafeDeleteDelegate safeDeleteDelegate = (JavaSafeDeleteDelegate)JavaSafeDeleteDelegate.EP.forLanguage(element.getLanguage());
                if (safeDeleteDelegate != null) {
                    safeDeleteDelegate.createUsageInfoForParameter(reference, usages, parameter, method);
                }
                if (!parameter.isVarArgs() && !RefactoringChangeUtil.isSuperMethodCall(element.getParent()) && (paramInCaller = SafeDeleteJavaCallerChooser.isTheOnlyOneParameterUsage(element.getParent(), parameterIndex, method)) != null) {
                    PsiMethod callerMethod = (PsiMethod)paramInCaller.getDeclarationScope();
                    if (ApplicationManager.getApplication().isUnitTestMode()) {
                        usages.add(new SafeDeleteParameterCallHierarchyUsageInfo(callerMethod, paramInCaller, callerMethod));
                    } else {
                        usages.add(new SafeDeleteParameterCallHierarchyUsageInfo(method, parameter, callerMethod));
                    }
                }
            }
            return true;
        });
        ReferencesSearch.search((PsiElement)parameter).forEach(reference -> {
            PsiElement element = reference.getElement();
            PsiDocTag docTag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTag.class);
            if (docTag != null) {
                usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)docTag, (PsiElement)parameter, true));
                return true;
            }
            boolean isSafeDelete = false;
            if (element.getParent().getParent() instanceof PsiMethodCallExpression) {
                PsiMethod superMethod;
                PsiMethodCallExpression call = (PsiMethodCallExpression)element.getParent().getParent();
                PsiReferenceExpression methodExpression = call.getMethodExpression();
                if (methodExpression.getText().equals("super")) {
                    isSafeDelete = true;
                } else if (methodExpression.getQualifierExpression() instanceof PsiSuperExpression && (superMethod = call.resolveMethod()) != null && MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method)) {
                    isSafeDelete = true;
                }
            }
            usages.add(new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)parameter, isSafeDelete));
            return true;
        });
        JavaSafeDeleteProcessor.findFunctionalExpressions(usages, method);
    }

    private static boolean isInside(PsiElement place, PsiElement[] ancestors) {
        return JavaSafeDeleteProcessor.isInside(place, Arrays.asList(ancestors));
    }

    private static boolean isInside(PsiElement place, Collection<? extends PsiElement> ancestors) {
        for (PsiElement psiElement : ancestors) {
            if (!JavaSafeDeleteProcessor.isInside(place, psiElement)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInside(PsiElement place, PsiElement ancestor) {
        PsiJavaFile file2;
        PsiClass aClass;
        if (SafeDeleteProcessor.isInside(place, ancestor)) {
            return true;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)place, PsiComment.class, (boolean)false) != null && ancestor instanceof PsiClass && (aClass = (PsiClass)ancestor).getParent() instanceof PsiJavaFile && PsiTreeUtil.isAncestor((PsiElement)(file2 = (PsiJavaFile)aClass.getParent()), (PsiElement)place, (boolean)false) && file2.getClasses().length == 1;
    }

    private static class SafeDeleteFunctionalExpressionUsageInfo
    extends SafeDeleteReferenceUsageInfo {
        public SafeDeleteFunctionalExpressionUsageInfo(@NotNull PsiElement element, PsiElement referencedElement) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor$SafeDeleteFunctionalExpressionUsageInfo", "<init>"));
            }
            super(element, referencedElement, false);
        }

        @Override
        public void deleteElement() throws IncorrectOperationException {
        }
    }
}

