/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.actions;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.typeMigration.ChangeTypeSignatureHandler;
import org.jetbrains.annotations.NotNull;

public class ChangeTypeSignatureAction
extends BaseRefactoringAction {
    @Override
    public boolean isAvailableInEditorOnly() {
        return false;
    }

    @Override
    public boolean isEnabledOnElements(@NotNull PsiElement[] elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/refactoring/typeMigration/actions/ChangeTypeSignatureAction", "isEnabledOnElements"));
        }
        Project currProject = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        if (currProject == null) {
            return false;
        }
        if (elements.length > 1) {
            return false;
        }
        for (PsiElement element : elements) {
            if (element instanceof PsiMethod || element instanceof PsiVariable) continue;
            return false;
        }
        return true;
    }

    @Override
    protected boolean isAvailableOnElementInEditorAndFile(@NotNull PsiElement element, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull DataContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/refactoring/typeMigration/actions/ChangeTypeSignatureAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/refactoring/typeMigration/actions/ChangeTypeSignatureAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/refactoring/typeMigration/actions/ChangeTypeSignatureAction", "isAvailableOnElementInEditorAndFile"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/refactoring/typeMigration/actions/ChangeTypeSignatureAction", "isAvailableOnElementInEditorAndFile"));
        }
        int offset = TargetElementUtil.adjustOffset(file2, editor.getDocument(), editor.getCaretModel().getOffset());
        PsiElement psiElement = file2.findElementAt(offset);
        PsiReferenceParameterList referenceParameterList = (PsiReferenceParameterList)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiReferenceParameterList.class);
        if (referenceParameterList != null) {
            return referenceParameterList.getTypeArguments().length > 0;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiTypeElement.class) != null;
    }

    @Override
    public RefactoringActionHandler getHandler(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/refactoring/typeMigration/actions/ChangeTypeSignatureAction", "getHandler"));
        }
        return new ChangeTypeSignatureHandler();
    }
}

