/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.inspections.GuavaConversionSettings;
import com.intellij.refactoring.typeMigration.rules.guava.BaseGuavaTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.FunctionalInterfaceTypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaLambda;
import com.intellij.util.IncorrectOperationException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaLambdaConversionRule
extends BaseGuavaTypeConversionRule {
    private static final Logger LOG = Logger.getInstance(GuavaLambdaConversionRule.class);
    private final GuavaLambda myLambda;

    protected GuavaLambdaConversionRule(GuavaLambda lambda2) {
        this.myLambda = lambda2;
    }

    @Override
    protected void fillSimpleDescriptors(Map<String, TypeConversionDescriptorBase> descriptorsMap) {
        descriptorsMap.put(this.myLambda.getSamName(), new FunctionalInterfaceTypeConversionDescriptor(this.myLambda.getSamName(), this.myLambda.getJavaAnalogueSamName(), this.myLambda.getJavaAnalogueClassQName()));
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForVariableReference(@NotNull PsiReferenceExpression referenceExpression, @NotNull PsiVariable psiVariable, PsiExpression context) {
        if (referenceExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "referenceExpression", "com/intellij/refactoring/typeMigration/rules/guava/GuavaLambdaConversionRule", "findConversionForVariableReference"));
        }
        if (psiVariable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiVariable", "com/intellij/refactoring/typeMigration/rules/guava/GuavaLambdaConversionRule", "findConversionForVariableReference"));
        }
        return new FunctionalInterfaceTypeConversionDescriptor(this.myLambda.getSamName(), this.myLambda.getJavaAnalogueSamName(), this.myLambda.getJavaAnalogueClassQName());
    }

    @Override
    @NotNull
    public String ruleFromClass() {
        String string = this.myLambda.getClassQName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaLambdaConversionRule", "ruleFromClass"));
        }
        return string;
    }

    @Override
    @NotNull
    public String ruleToClass() {
        String string = this.myLambda.getJavaAnalogueClassQName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/typeMigration/rules/guava/GuavaLambdaConversionRule", "ruleToClass"));
        }
        return string;
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForAnonymous(@NotNull PsiAnonymousClass anonymousClass, GuavaConversionSettings settings) {
        if (anonymousClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anonymousClass", "com/intellij/refactoring/typeMigration/rules/guava/GuavaLambdaConversionRule", "findConversionForAnonymous"));
        }
        TypeConversionDescriptorBase conversion = super.findConversionForAnonymous(anonymousClass, settings);
        if (conversion != null) {
            return conversion;
        }
        PsiClass baseClass = anonymousClass.getBaseClassType().resolve();
        return baseClass != null && this.myLambda.getClassQName().equals(baseClass.getQualifiedName()) ? new ConvertLambdaClassToJavaClassDescriptor() : null;
    }

    private static class ConvertLambdaClassToJavaClassDescriptor
    extends TypeConversionDescriptorBase {
        private ConvertLambdaClassToJavaClassDescriptor() {
        }

        @Override
        public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
            if (evaluator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/rules/guava/GuavaLambdaConversionRule$ConvertLambdaClassToJavaClassDescriptor", "replace"));
            }
            return GuavaConversionUtil.tryConvertClassAndSamNameToJava((PsiNewExpression)expression);
        }
    }

    public static class Supplier
    extends GuavaLambdaConversionRule {
        public Supplier() {
            super(GuavaLambda.SUPPLIER);
        }
    }

    public static class Function
    extends GuavaLambdaConversionRule {
        public Function() {
            super(GuavaLambda.FUNCTION);
        }
    }
}

