/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.Matcher;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GuavaOptionalConversionUtil {
    static boolean isOptionalOrContext(@Nullable PsiExpression context) {
        if (context == null) {
            return false;
        }
        PsiElement parent = context.getParent();
        if (parent == null) {
            return false;
        }
        PsiElement maybeMethodCall = parent.getParent();
        if (!(maybeMethodCall instanceof PsiMethodCallExpression)) {
            return false;
        }
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)maybeMethodCall;
        int argumentLength = methodCall.getArgumentList().getExpressions().length;
        if (argumentLength != 1) {
            return false;
        }
        PsiMethod resolvedMethod = methodCall.resolveMethod();
        if (resolvedMethod == null || !"or".equals(resolvedMethod.getName())) {
            return false;
        }
        PsiClass aClass = resolvedMethod.getContainingClass();
        return aClass != null && "com.google.common.base.Optional".equals(aClass.getQualifiedName());
    }

    static String simplifyParameterPattern(PsiMethodCallExpression methodCall) {
        PsiExpressionList argumentList = methodCall.getArgumentList();
        PsiExpression[] expressions = argumentList.getExpressions();
        if (expressions.length == 1) {
            MatchResult result2;
            PsiExpression expression = expressions[0];
            Matcher matcher = new Matcher(methodCall.getProject());
            MatchOptions options = new MatchOptions();
            options.setFileType((FileType)StdFileTypes.JAVA);
            List<MatchResult> results = matcher.testFindMatches(expression.getText(), "Optional.fromNullable($o$.orElse(null))", options, false);
            if (!results.isEmpty() && (result2 = results.get(0)).getStart() == 0 && result2.getEnd() == -1) {
                return "Optional.fromNullable($o$.orElse(null))";
            }
        }
        return "$o$";
    }
}

