/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classMembers;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;

public abstract class ClassMemberReferencesVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final PsiClass myClass;

    public ClassMemberReferencesVisitor(PsiClass aClass) {
        this.myClass = aClass;
    }

    public void visitReferenceExpression(PsiReferenceExpression expression) {
        PsiClass containingClass;
        PsiElement referencedElement;
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression) && !(qualifier instanceof PsiSuperExpression)) {
            qualifier.accept((PsiElementVisitor)this);
            if (!(qualifier instanceof PsiReferenceExpression) || !(((PsiReferenceExpression)qualifier).resolve() instanceof PsiClass)) {
                return;
            }
        }
        if ((referencedElement = expression.resolve()) instanceof PsiMember && ClassMemberReferencesVisitor.isPartOf(this.myClass, containingClass = ((PsiMember)referencedElement).getContainingClass())) {
            this.visitClassMemberReferenceExpression((PsiMember)referencedElement, expression);
        }
    }

    private static boolean isPartOf(PsiClass elementClass, PsiClass containingClass) {
        if (containingClass == null) {
            return false;
        }
        if (elementClass.equals(containingClass) || elementClass.isInheritor(containingClass, true)) {
            return true;
        }
        return PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)elementClass, (boolean)true);
    }

    protected void visitClassMemberReferenceExpression(PsiMember classMember, PsiReferenceExpression classMemberReferenceExpression) {
        this.visitClassMemberReferenceElement(classMember, (PsiJavaCodeReferenceElement)classMemberReferenceExpression);
    }

    protected abstract void visitClassMemberReferenceElement(PsiMember var1, PsiJavaCodeReferenceElement var2);

    public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        PsiElement referencedElement = reference.resolve();
        if (referencedElement instanceof PsiClass) {
            PsiClass referencedClass = (PsiClass)referencedElement;
            if (PsiTreeUtil.isAncestor((PsiElement)this.myClass, (PsiElement)referencedElement, (boolean)true)) {
                this.visitClassMemberReferenceElement((PsiMember)referencedElement, reference);
            } else if (ClassMemberReferencesVisitor.isPartOf(this.myClass, referencedClass.getContainingClass())) {
                this.visitClassMemberReferenceElement((PsiMember)referencedElement, reference);
            }
        }
    }

    protected final PsiClass getPsiClass() {
        return this.myClass;
    }
}

