/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.deployment;

import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.debug.DebugConnector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentTaskImpl<D extends DeploymentConfiguration>
implements DeploymentTask<D> {
    private final DeploymentSource mySource;
    private final D myConfiguration;
    private final Project myProject;
    private final DebugConnector<?, ?> myDebugConnector;
    private final ExecutionEnvironment myExecutionEnvironment;

    public DeploymentTaskImpl(DeploymentSource source, D configuration, Project project2, DebugConnector<?, ?> connector, ExecutionEnvironment environment) {
        this.mySource = source;
        this.myConfiguration = configuration;
        this.myProject = project2;
        this.myDebugConnector = connector;
        this.myExecutionEnvironment = environment;
    }

    @NotNull
    public DeploymentSource getSource() {
        DeploymentSource deploymentSource = this.mySource;
        if (deploymentSource == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentTaskImpl", "getSource"));
        }
        return deploymentSource;
    }

    @NotNull
    public D getConfiguration() {
        D d = this.myConfiguration;
        if (d == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentTaskImpl", "getConfiguration"));
        }
        return d;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentTaskImpl", "getProject"));
        }
        return project2;
    }

    public boolean isDebugMode() {
        return this.myDebugConnector != null;
    }

    @Nullable
    public DebugConnector<?, ?> getDebugConnector() {
        return this.myDebugConnector;
    }

    @NotNull
    public ExecutionEnvironment getExecutionEnvironment() {
        ExecutionEnvironment executionEnvironment = this.myExecutionEnvironment;
        if (executionEnvironment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentTaskImpl", "getExecutionEnvironment"));
        }
        return executionEnvironment;
    }
}

