/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.slicer.JavaSliceDereferenceUsage;
import com.intellij.slicer.JavaSliceUsage;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Processor;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SliceForwardUtil {
    SliceForwardUtil() {
    }

    static boolean processUsagesFlownFromThe(@NotNull PsiElement element, @NotNull JavaSliceUsage parent, @NotNull Processor<SliceUsage> processor2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceForwardUtil", "processUsagesFlownFromThe"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceForwardUtil", "processUsagesFlownFromThe"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceForwardUtil", "processUsagesFlownFromThe"));
        }
        Pair<PsiElement, PsiSubstitutor> pair = SliceForwardUtil.getAssignmentTarget(element, parent);
        if (pair != null) {
            PsiParameter parameter;
            PsiElement declarationScope;
            PsiElement target = (PsiElement)pair.getFirst();
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.getSecond();
            if (target instanceof PsiParameter && (declarationScope = (parameter = (PsiParameter)target).getDeclarationScope()) instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)declarationScope;
                int parameterIndex = method.getParameterList().getParameterIndex(parameter);
                Processor myProcessor = override -> {
                    if (parent == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceForwardUtil", "lambda$processUsagesFlownFromThe$0"));
                    }
                    if (processor2 == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceForwardUtil", "lambda$processUsagesFlownFromThe$0"));
                    }
                    if (!parent.getScope().contains((PsiElement)override)) {
                        return true;
                    }
                    PsiSubstitutor superSubstitutor = method == override ? substitutor : MethodSignatureUtil.getSuperMethodSignatureSubstitutor((MethodSignature)method.getSignature(substitutor), (MethodSignature)override.getSignature(substitutor));
                    PsiParameter[] parameters = override.getParameterList().getParameters();
                    if (parameters.length <= parameterIndex) {
                        return true;
                    }
                    PsiParameter actualParam = parameters[parameterIndex];
                    SliceUsage usage = SliceUtil.createSliceUsage((PsiElement)actualParam, parent, superSubstitutor, parent.indexNesting, "");
                    return processor2.process((Object)usage);
                };
                if (!myProcessor.process((Object)method)) {
                    return false;
                }
                return OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach(myProcessor);
            }
            SliceUsage usage = SliceUtil.createSliceUsage(target, parent, parent.getSubstitutor(), parent.indexNesting, "");
            return processor2.process((Object)usage);
        }
        if (element instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)element;
            PsiElement resolved = ref.resolve();
            if (!(resolved instanceof PsiVariable)) {
                return true;
            }
            PsiVariable variable = (PsiVariable)resolved;
            return SliceForwardUtil.processAssignedFrom((PsiElement)variable, (PsiElement)ref, parent, processor2);
        }
        if (element instanceof PsiVariable) {
            return SliceForwardUtil.processAssignedFrom(element, element, parent, processor2);
        }
        if (element instanceof PsiMethod) {
            return SliceForwardUtil.processAssignedFrom(element, element, parent, processor2);
        }
        return true;
    }

    private static boolean processAssignedFrom(@NotNull PsiElement from, @NotNull PsiElement context, @NotNull JavaSliceUsage parent, @NotNull Processor<SliceUsage> processor2) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/slicer/SliceForwardUtil", "processAssignedFrom"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/slicer/SliceForwardUtil", "processAssignedFrom"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceForwardUtil", "processAssignedFrom"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceForwardUtil", "processAssignedFrom"));
        }
        if (from instanceof PsiLocalVariable) {
            return SliceForwardUtil.searchReferencesAndProcessAssignmentTarget(from, context, parent, processor2);
        }
        if (from instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)from;
            PsiElement scope = parameter.getDeclarationScope();
            THashSet parametersToAnalyze = new THashSet();
            if (scope instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                int index = method.getParameterList().getParameterIndex(parameter);
                THashSet superMethods = new THashSet(Arrays.asList(method.findDeepestSuperMethods()));
                superMethods.add(method);
                Iterator iterator = superMethods.iterator();
                while (iterator.hasNext()) {
                    ProgressManager.checkCanceled();
                    PsiMethod superMethod = (PsiMethod)iterator.next();
                    if (parent.params.scope.contains((PsiElement)superMethod)) continue;
                    iterator.remove();
                }
                THashSet implementors = new THashSet((Collection)superMethods);
                for (PsiMethod superMethod : superMethods) {
                    ProgressManager.checkCanceled();
                    if (OverridingMethodsSearch.search((PsiMethod)superMethod, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach(sub -> {
                        ProgressManager.checkCanceled();
                        implementors.add(sub);
                        return true;
                    })) continue;
                    return false;
                }
                for (PsiMethod implementor : implementors) {
                    ProgressManager.checkCanceled();
                    if (!parent.params.scope.contains((PsiElement)implementor)) continue;
                    if (implementor instanceof PsiCompiledElement) {
                        implementor = (PsiMethod)implementor.getNavigationElement();
                    }
                    PsiParameter[] parameters = implementor.getParameterList().getParameters();
                    if (index == -1 || index >= parameters.length) continue;
                    parametersToAnalyze.add(parameters[index]);
                }
            } else {
                parametersToAnalyze.add(parameter);
            }
            for (PsiParameter psiParameter : parametersToAnalyze) {
                ProgressManager.checkCanceled();
                if (SliceForwardUtil.searchReferencesAndProcessAssignmentTarget((PsiElement)psiParameter, null, parent, processor2)) continue;
                return false;
            }
            return true;
        }
        if (from instanceof PsiField) {
            return SliceForwardUtil.searchReferencesAndProcessAssignmentTarget(from, null, parent, processor2);
        }
        if (from instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)from;
            THashSet superMethods = new THashSet(Arrays.asList(method.findDeepestSuperMethods()));
            superMethods.add(method);
            THashSet processed2 = new THashSet();
            for (PsiMethod containingMethod : superMethods) {
                if (MethodReferencesSearch.search((PsiMethod)containingMethod, (SearchScope)parent.getScope().toSearchScope(), (boolean)true).forEach(arg_0 -> SliceForwardUtil.lambda$processAssignedFrom$2((Set)processed2, parent, processor2, arg_0))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean searchReferencesAndProcessAssignmentTarget(@NotNull PsiElement element, @Nullable PsiElement context, @NotNull JavaSliceUsage parent, @NotNull Processor<SliceUsage> processor2) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceForwardUtil", "searchReferencesAndProcessAssignmentTarget"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceForwardUtil", "searchReferencesAndProcessAssignmentTarget"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceForwardUtil", "searchReferencesAndProcessAssignmentTarget"));
        }
        return ReferencesSearch.search((PsiElement)element).forEach(reference -> {
            if (parent == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceForwardUtil", "lambda$searchReferencesAndProcessAssignmentTarget$3"));
            }
            if (processor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceForwardUtil", "lambda$searchReferencesAndProcessAssignmentTarget$3"));
            }
            PsiElement element1 = reference.getElement();
            if (context != null && element1.getTextOffset() < context.getTextOffset()) {
                return true;
            }
            return SliceForwardUtil.processAssignmentTarget(element1, parent, processor2);
        });
    }

    private static boolean processAssignmentTarget(@NotNull PsiElement element, @NotNull JavaSliceUsage parent, @NotNull Processor<SliceUsage> processor2) {
        Pair<PsiElement, PsiSubstitutor> pair;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceForwardUtil", "processAssignmentTarget"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceForwardUtil", "processAssignmentTarget"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceForwardUtil", "processAssignmentTarget"));
        }
        if (!parent.params.scope.contains(element)) {
            return true;
        }
        if (element instanceof PsiCompiledElement) {
            element = element.getNavigationElement();
        }
        if ((pair = SliceForwardUtil.getAssignmentTarget(element, parent)) != null) {
            SliceUsage usage = SliceUtil.createSliceUsage(element, parent, (PsiSubstitutor)pair.getSecond(), parent.indexNesting, "");
            return processor2.process((Object)usage);
        }
        if (parent.params.showInstanceDereferences && SliceForwardUtil.isDereferenced(element)) {
            JavaSliceDereferenceUsage usage = new JavaSliceDereferenceUsage(element.getParent(), parent, parent.getSubstitutor());
            return processor2.process((Object)usage);
        }
        return true;
    }

    private static boolean isDereferenced(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceForwardUtil", "isDereferenced"));
        }
        if (!(element instanceof PsiReferenceExpression)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (!(parent instanceof PsiReferenceExpression)) {
            return false;
        }
        return ((PsiReferenceExpression)parent).getQualifierExpression() == element;
    }

    private static Pair<PsiElement, PsiSubstitutor> getAssignmentTarget(@NotNull PsiElement element, @NotNull JavaSliceUsage parentUsage) {
        PsiReturnStatement statement2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceForwardUtil", "getAssignmentTarget"));
        }
        if (parentUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentUsage", "com/intellij/slicer/SliceForwardUtil", "getAssignmentTarget"));
        }
        element = SliceForwardUtil.complexify(element);
        PsiVariable target = null;
        PsiSubstitutor substitutor = parentUsage.getSubstitutor();
        PsiElement parent = element.getParent();
        if (parent instanceof PsiAssignmentExpression) {
            PsiExpression left;
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
            if (element.equals(assignment.getRExpression()) && (left = assignment.getLExpression()) instanceof PsiReferenceExpression) {
                JavaResolveResult result2 = ((PsiReferenceExpression)left).advancedResolve(false);
                target = result2.getElement();
                substitutor = result2.getSubstitutor();
            }
        } else if (parent instanceof PsiVariable) {
            PsiVariable variable = (PsiVariable)parent;
            PsiExpression initializer = variable.getInitializer();
            if (element.equals(initializer)) {
                target = variable;
            }
        } else if (parent instanceof PsiExpressionList && parent.getParent() instanceof PsiCallExpression) {
            PsiParameter[] parameters;
            Object[] expressions = ((PsiExpressionList)parent).getExpressions();
            int index = ArrayUtilRt.find((Object[])expressions, (Object)element);
            PsiCallExpression methodCall = (PsiCallExpression)parent.getParent();
            JavaResolveResult result3 = methodCall.resolveMethodGenerics();
            PsiMethod method = (PsiMethod)result3.getElement();
            if (index != -1 && method != null && index < (parameters = method.getParameterList().getParameters()).length) {
                target = parameters[index];
                substitutor = result3.getSubstitutor();
            }
        } else if (parent instanceof PsiReturnStatement && element.equals((statement2 = (PsiReturnStatement)parent).getReturnValue())) {
            target = PsiTreeUtil.getParentOfType((PsiElement)statement2, PsiMethod.class);
        }
        return target == null ? null : Pair.create(target, (Object)substitutor);
    }

    @NotNull
    static PsiElement complexify(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/slicer/SliceForwardUtil", "complexify"));
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PsiParenthesizedExpression && element.equals(((PsiParenthesizedExpression)parent).getExpression())) {
            PsiElement psiElement = SliceForwardUtil.complexify(parent);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceForwardUtil", "complexify"));
            }
            return psiElement;
        }
        if (parent instanceof PsiTypeCastExpression && element.equals(((PsiTypeCastExpression)parent).getOperand())) {
            PsiElement psiElement = SliceForwardUtil.complexify(parent);
            if (psiElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceForwardUtil", "complexify"));
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/slicer/SliceForwardUtil", "complexify"));
        }
        return psiElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static /* synthetic */ boolean lambda$processAssignedFrom$2(Set processed2, @NotNull JavaSliceUsage parent, @NotNull Processor processor2, PsiReference reference) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/slicer/SliceForwardUtil", "lambda$processAssignedFrom$2"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/slicer/SliceForwardUtil", "lambda$processAssignedFrom$2"));
        }
        ProgressManager.checkCanceled();
        Set set = processed2;
        synchronized (set) {
            if (!processed2.add(reference)) {
                return true;
            }
        }
        PsiElement element = reference.getElement().getParent();
        return SliceForwardUtil.processAssignmentTarget(element, parent, (Processor<SliceUsage>)processor2);
    }
}

