/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.structuralsearch.plugin.StructuralSearchPlugin;
import com.intellij.structuralsearch.plugin.replace.ui.ReplaceDialog;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;

public class StructuralReplaceAction
extends AnAction {
    public void actionPerformed(AnActionEvent event) {
        StructuralReplaceAction.triggerAction(null, SearchContext.buildFromDataContext(event.getDataContext()));
    }

    public static void triggerAction(Configuration config, SearchContext searchContext) {
        Project project2 = searchContext.getProject();
        if (project2 == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        ReplaceDialog replaceDialog = new ReplaceDialog(searchContext);
        if (config != null) {
            replaceDialog.setUseLastConfiguration(true);
            replaceDialog.setValuesFromConfig(config);
        }
        replaceDialog.show();
    }

    public void update(AnActionEvent event) {
        StructuralSearchPlugin plugin;
        Presentation presentation = event.getPresentation();
        DataContext context = event.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(context);
        StructuralSearchPlugin structuralSearchPlugin = plugin = project2 == null ? null : StructuralSearchPlugin.getInstance(project2);
        if (plugin == null || plugin.isSearchInProgress() || plugin.isReplaceInProgress() || plugin.isDialogVisible()) {
            presentation.setEnabled(false);
        } else {
            presentation.setEnabled(true);
        }
        super.update(event);
    }
}

