/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import com.intellij.codeInsight.hint.TooltipController;
import com.intellij.codeInsight.template.impl.TemplateImplUtil;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.util.Key;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.UIUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class SubstitutionShortInfoHandler
implements DocumentListener,
EditorMouseMotionListener,
CaretListener {
    private long modificationTimeStamp;
    private final ArrayList<Variable> variables;
    private final Editor editor;
    public static final Key<Configuration> CURRENT_CONFIGURATION_KEY = Key.create((String)"SS.CurrentConfiguration");

    SubstitutionShortInfoHandler(@NotNull Editor _editor) {
        if (_editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "_editor", "com/intellij/structuralsearch/plugin/ui/SubstitutionShortInfoHandler", "<init>"));
        }
        this.variables = new ArrayList();
        this.editor = _editor;
    }

    public void beforeDocumentChange(DocumentEvent event) {
    }

    public void documentChanged(DocumentEvent event) {
    }

    public void mouseMoved(EditorMouseEvent e) {
        LogicalPosition position = this.editor.xyToLogicalPosition(e.getMouseEvent().getPoint());
        this.handleInputFocusMovement(position);
    }

    private void handleInputFocusMovement(LogicalPosition position) {
        int start;
        this.checkModelValidity();
        String text = "";
        int offset = this.editor.logicalPositionToOffset(position);
        int length = this.editor.getDocument().getTextLength();
        CharSequence elements = this.editor.getDocument().getCharsSequence();
        int end = -1;
        for (start = offset - 1; start >= 0 && Character.isJavaIdentifierPart(elements.charAt(start)) && elements.charAt(start) != '$'; --start) {
        }
        if (start >= 0 && elements.charAt(start) == '$') {
            for (end = offset; end < length && Character.isJavaIdentifierPart(elements.charAt(end)) && elements.charAt(end) != '$'; ++end) {
            }
            if (end < length && elements.charAt(end) == '$') {
                String varname = elements.subSequence(start + 1, end).toString();
                Variable foundVar = null;
                for (Variable var : this.variables) {
                    if (!var.getName().equals(varname)) continue;
                    foundVar = var;
                    break;
                }
                if (foundVar != null) {
                    text = UIUtil.getShortParamString((Configuration)this.editor.getUserData(CURRENT_CONFIGURATION_KEY), varname);
                }
            }
        }
        if (text.length() > 0) {
            UIUtil.showTooltip(this.editor, start, end + 1, text);
        } else {
            TooltipController.getInstance().cancelTooltips();
        }
    }

    private void checkModelValidity() {
        Document document2 = this.editor.getDocument();
        if (this.modificationTimeStamp != document2.getModificationStamp()) {
            this.variables.clear();
            this.variables.addAll(TemplateImplUtil.parseVariables(document2.getCharsSequence()).values());
            this.modificationTimeStamp = document2.getModificationStamp();
        }
    }

    public void mouseDragged(EditorMouseEvent e) {
    }

    public void caretPositionChanged(CaretEvent e) {
        this.handleInputFocusMovement(e.getNewPosition());
    }

    public void caretAdded(CaretEvent e) {
    }

    public void caretRemoved(CaretEvent e) {
    }

    public ArrayList<Variable> getVariables() {
        this.checkModelValidity();
        return this.variables;
    }
}

