/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FileTreeAccessFilter
implements VirtualFileFilter {
    private final Set<VirtualFile> myAddedClasses = new THashSet();
    private boolean myTreeAccessAllowed;

    public boolean accept(VirtualFile file2) {
        if (file2 instanceof VirtualFileWindow) {
            return false;
        }
        if (this.myAddedClasses.contains(file2) || this.myTreeAccessAllowed) {
            return false;
        }
        FileType fileType = file2.getFileType();
        return (fileType == StdFileTypes.JAVA || fileType == StdFileTypes.CLASS) && !file2.getName().equals("package-info.java");
    }

    public void allowTreeAccessForFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/FileTreeAccessFilter", "allowTreeAccessForFile"));
        }
        this.myAddedClasses.add(file2);
    }

    public void allowTreeAccessForAllFiles() {
        this.myTreeAccessAllowed = true;
    }

    public String toString() {
        return "JAVA {allowed=" + this.myTreeAccessAllowed + " files=" + new ArrayList<VirtualFile>(this.myAddedClasses) + "}";
    }
}

