/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.generation.actions.CommentByLineCommentAction;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandler;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.TypedAction;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.TrailingSpacesStripper;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.EditorTestUtil;
import com.intellij.testFramework.FileBasedTestCaseHelper;
import com.intellij.testFramework.FileBasedTestCaseHelperEx;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.Parameterized;
import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.After;
import org.junit.Before;
import org.junit.runners.Parameterized;

public abstract class LightPlatformCodeInsightTestCase
extends LightPlatformTestCase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.testFramework.LightCodeInsightTestCase");
    protected static Editor myEditor;
    protected static PsiFile myFile;
    protected static VirtualFile myVFile;
    @Parameterized.Parameter(value=0)
    public String myFileSuffix;
    @Parameterized.Parameter(value=1)
    public String myTestDataPath;

    @Override
    protected void runTest() throws Throwable {
        if (this.isRunInWriteAction()) {
            WriteCommandAction.runWriteCommandAction((Project)LightPlatformCodeInsightTestCase.getProject(), () -> {
                this.doRunTest();
                return null;
            });
        } else {
            new WriteCommandAction.Simple(LightPlatformCodeInsightTestCase.getProject(), new PsiFile[0]){

                protected void run() throws Throwable {
                    LightPlatformCodeInsightTestCase.this.doRunTest();
                }
            }.performCommand();
        }
    }

    protected void doRunTest() throws Throwable {
        LightPlatformCodeInsightTestCase.super.runTest();
    }

    protected boolean isRunInWriteAction() {
        return false;
    }

    protected void configureByFile(@NonNls @NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureByFile"));
        }
        try {
            File ioFile = new File(this.getTestDataPath() + filePath);
            String fileText = FileUtilRt.loadFile((File)ioFile, (String)"UTF-8", (boolean)true);
            LightPlatformCodeInsightTestCase.configureFromFileText(ioFile.getName(), fileText);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNls
    @NotNull
    protected String getTestDataPath() {
        if (this.myTestDataPath != null) {
            String string = this.myTestDataPath;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getTestDataPath"));
            }
            return string;
        }
        String string = PathManagerEx.getTestDataPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getTestDataPath"));
        }
        return string;
    }

    @NotNull
    protected VirtualFile getVirtualFile(@NonNls @NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getVirtualFile"));
        }
        String fullPath = this.getTestDataPath() + filePath;
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(fullPath.replace(File.separatorChar, '/'));
        LightPlatformCodeInsightTestCase.assertNotNull((String)("file " + fullPath + " not found"), (Object)vFile);
        VirtualFile virtualFile = vFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getVirtualFile"));
        }
        return virtualFile;
    }

    @NotNull
    protected static Document configureFromFileText(final @NonNls @NotNull String fileName, final @NonNls @NotNull String fileText) {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileText"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileText"));
        }
        Document document2 = (Document)new WriteCommandAction<Document>(null, new PsiFile[0]){

            protected void run(@NotNull Result<Document> result2) throws Throwable {
                Document document2;
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/LightPlatformCodeInsightTestCase$2", "run"));
                }
                if (myVFile != null) {
                    PsiDocumentManager.getInstance((Project)LightPlatformTestCase.ourProject).commitAllDocuments();
                    FileEditorManager.getInstance((Project)LightPlatformTestCase.ourProject).closeFile(myVFile);
                    try {
                        myVFile.delete((Object)this);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                    myVFile = null;
                }
                DocumentImpl fakeDocument = new DocumentImpl(fileText);
                EditorTestUtil.CaretAndSelectionState caretsState = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
                String newFileText = fakeDocument.getText();
                try {
                    document2 = LightPlatformCodeInsightTestCase.setupFileEditorAndDocument(fileName, newFileText);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                EditorTestUtil.setCaretsAndSelection(myEditor, caretsState);
                LightPlatformCodeInsightTestCase.setupEditorForInjectedLanguage();
                result2.setResult((Object)document2);
            }
        }.execute().getResultObject();
        if (document2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileText"));
        }
        return document2;
    }

    @NotNull
    protected static Editor configureFromFileTextWithoutPSI(final @NonNls @NotNull String fileText) {
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileTextWithoutPSI"));
        }
        Editor editor = (Editor)new WriteCommandAction<Editor>(null, new PsiFile[0]){

            protected void run(@NotNull Result<Editor> result2) throws Throwable {
                if (result2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/LightPlatformCodeInsightTestCase$3", "run"));
                }
                Document fakeDocument = EditorFactory.getInstance().createDocument((CharSequence)fileText);
                EditorTestUtil.CaretAndSelectionState caretsState = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
                String newFileText = fakeDocument.getText();
                Document document2 = EditorFactory.getInstance().createDocument((CharSequence)newFileText);
                Editor editor = EditorFactory.getInstance().createEditor(document2);
                ((EditorImpl)editor).setCaretActive();
                EditorTestUtil.setCaretsAndSelection(editor, caretsState);
                result2.setResult((Object)editor);
            }
        }.execute().getResultObject();
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "configureFromFileTextWithoutPSI"));
        }
        return editor;
    }

    @NotNull
    protected static Editor createEditor(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "createEditor"));
        }
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        Editor editor = FileEditorManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).openTextEditor(new OpenFileDescriptor(LightPlatformCodeInsightTestCase.getProject(), file2, 0), false);
        DaemonCodeAnalyzer.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).restart();
        ((EditorImpl)editor).setCaretActive();
        Editor editor2 = editor;
        if (editor2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "createEditor"));
        }
        return editor2;
    }

    @NotNull
    private static Document setupFileEditorAndDocument(@NotNull String fileName, @NotNull String fileText) throws IOException {
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "setupFileEditorAndDocument"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "setupFileEditorAndDocument"));
        }
        EncodingProjectManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).setEncoding(null, CharsetToolkit.UTF8_CHARSET);
        EncodingProjectManager.getInstance((Project)ProjectManager.getInstance().getDefaultProject()).setEncoding(null, CharsetToolkit.UTF8_CHARSET);
        PostprocessReformattingAspect.getInstance(ourProject).doPostponedFormatting();
        LightPlatformCodeInsightTestCase.deleteVFile();
        myVFile = LightPlatformCodeInsightTestCase.getSourceRoot().createChildData(null, fileName);
        VfsUtil.saveText((VirtualFile)myVFile, (String)fileText);
        FileDocumentManager manager = FileDocumentManager.getInstance();
        Document document2 = manager.getDocument(myVFile);
        LightPlatformCodeInsightTestCase.assertNotNull((String)("Can't create document for '" + fileName + "'"), (Object)document2);
        manager.reloadFromDisk(document2);
        document2.insertString(0, (CharSequence)" ");
        document2.deleteString(0, 1);
        myFile = LightPlatformCodeInsightTestCase.getPsiManager().findFile(myVFile);
        LightPlatformCodeInsightTestCase.assertNotNull((String)("Can't create PsiFile for '" + fileName + "'. Unknown file type most probably."), (Object)myFile);
        LightPlatformCodeInsightTestCase.assertTrue((boolean)myFile.isPhysical());
        myEditor = LightPlatformCodeInsightTestCase.createEditor(myVFile);
        myVFile.setCharset(CharsetToolkit.UTF8_CHARSET);
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        Document document3 = document2;
        if (document3 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "setupFileEditorAndDocument"));
        }
        return document3;
    }

    private static void setupEditorForInjectedLanguage() {
        if (myEditor != null) {
            Ref editorWindowRef = new Ref();
            myEditor.getCaretModel().runForEachCaret(caret -> {
                Editor editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(myEditor, myFile);
                if (caret == myEditor.getCaretModel().getPrimaryCaret() && editor instanceof EditorWindow) {
                    editorWindowRef.set((Object)((EditorWindow)editor));
                }
            });
            if (!editorWindowRef.isNull()) {
                myEditor = (Editor)editorWindowRef.get();
                myFile = ((EditorWindow)editorWindowRef.get()).getInjectedFile();
            }
        }
    }

    private static void deleteVFile() throws IOException {
        if (myVFile != null) {
            ApplicationManager.getApplication().runWriteAction((ThrowableComputable)new ThrowableComputable<Void, IOException>(){

                public Void compute() throws IOException {
                    myVFile.delete((Object)this);
                    return null;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void tearDown() throws Exception {
        try {
            VirtualFile[] openFiles;
            FileEditorManager editorManager = FileEditorManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject());
            for (VirtualFile openFile2 : openFiles = editorManager.getOpenFiles()) {
                editorManager.closeFile(openFile2);
            }
            LightPlatformCodeInsightTestCase.deleteVFile();
            myEditor = null;
            myFile = null;
            myVFile = null;
        }
        finally {
            super.tearDown();
        }
    }

    protected void checkResultByFile(@NonNls @NotNull String filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByFile"));
        }
        this.checkResultByFile(null, filePath, false);
    }

    protected void checkResultByFile(@Nullable String message, @NotNull String filePath, boolean ignoreTrailingSpaces) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByFile"));
        }
        LightPlatformCodeInsightTestCase.bringRealEditorBack();
        ((PostprocessReformattingAspect)LightPlatformCodeInsightTestCase.getProject().getComponent(PostprocessReformattingAspect.class)).doPostponedFormatting();
        if (ignoreTrailingSpaces) {
            Editor editor = myEditor;
            TrailingSpacesStripper.stripIfNotCurrentLine(editor.getDocument(), false);
            EditorUtil.fillVirtualSpaceUntilCaret(editor);
        }
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        String fullPath = this.getTestDataPath() + filePath;
        File ioFile = new File(fullPath);
        LightPlatformCodeInsightTestCase.assertTrue((String)LightPlatformCodeInsightTestCase.getMessage("Cannot find file " + fullPath, message), (boolean)ioFile.exists());
        String fileText = null;
        try {
            fileText = FileUtil.loadFile((File)ioFile, (Charset)CharsetToolkit.UTF8_CHARSET);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        this.checkResultByText(message, StringUtil.convertLineSeparators((String)fileText), ignoreTrailingSpaces, this.getTestDataPath() + "/" + filePath);
    }

    protected void checkResultByText(@NonNls @NotNull String fileText) {
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByText"));
        }
        this.checkResultByText(null, fileText, false, null);
    }

    protected void checkResultByText(String message, @NotNull String fileText, boolean ignoreTrailingSpaces) {
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByText"));
        }
        this.checkResultByText(message, fileText, ignoreTrailingSpaces, null);
    }

    protected void checkResultByText(String message, @NotNull String fileText, boolean ignoreTrailingSpaces, String filePath) {
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByText"));
        }
        LightPlatformCodeInsightTestCase.bringRealEditorBack();
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (fileText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$checkResultByText$2"));
            }
            Document document2 = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            if (ignoreTrailingSpaces) {
                ((DocumentImpl)document2).stripTrailingSpaces(LightPlatformCodeInsightTestCase.getProject());
            }
            EditorTestUtil.CaretAndSelectionState carets = EditorTestUtil.extractCaretAndSelectionMarkers(document2);
            PostprocessReformattingAspect.getInstance(LightPlatformCodeInsightTestCase.getProject()).doPostponedFormatting();
            String newFileText = document2.getText();
            PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
            String fileText1 = myFile.getText();
            String failMessage = LightPlatformCodeInsightTestCase.getMessage("Text mismatch", message);
            if (filePath != null && !newFileText.equals(fileText1)) {
                throw new FileComparisonFailure(failMessage, newFileText, fileText1, filePath);
            }
            LightPlatformCodeInsightTestCase.assertEquals((String)failMessage, (String)newFileText, (String)fileText1);
            EditorTestUtil.verifyCaretAndSelectionState(myEditor, carets, message);
        });
    }

    protected static void checkResultByTextWithoutPSI(String message, @NotNull Editor editor, @NotNull String fileText, boolean ignoreTrailingSpaces, String filePath) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByTextWithoutPSI"));
        }
        if (fileText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "checkResultByTextWithoutPSI"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (fileText == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileText", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$checkResultByTextWithoutPSI$3"));
            }
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$checkResultByTextWithoutPSI$3"));
            }
            Document fakeDocument = EditorFactory.getInstance().createDocument((CharSequence)fileText);
            if (ignoreTrailingSpaces) {
                ((DocumentImpl)fakeDocument).stripTrailingSpaces(LightPlatformCodeInsightTestCase.getProject());
            }
            EditorTestUtil.CaretAndSelectionState carets = EditorTestUtil.extractCaretAndSelectionMarkers(fakeDocument);
            String newFileText = fakeDocument.getText();
            String fileText1 = editor.getDocument().getText();
            String failMessage = LightPlatformCodeInsightTestCase.getMessage("Text mismatch", message);
            if (filePath != null && !newFileText.equals(fileText1)) {
                throw new FileComparisonFailure(failMessage, newFileText, fileText1, filePath);
            }
            LightPlatformCodeInsightTestCase.assertEquals((String)failMessage, (String)newFileText, (String)fileText1);
            EditorTestUtil.verifyCaretAndSelectionState(editor, carets, message);
        });
    }

    @NotNull
    private static String getMessage(@NonNls @NotNull String engineMessage, String userMessage) {
        if (engineMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engineMessage", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getMessage"));
        }
        if (userMessage == null) {
            String string = engineMessage;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getMessage"));
            }
            return string;
        }
        String string = userMessage + " [" + engineMessage + "]";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getMessage"));
        }
        return string;
    }

    protected static Editor getEditor() {
        return myEditor;
    }

    protected static PsiFile getFile() {
        return myFile;
    }

    protected static VirtualFile getVFile() {
        return myVFile;
    }

    protected static void bringRealEditorBack() {
        PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).commitAllDocuments();
        if (myEditor instanceof EditorWindow) {
            Document document2 = ((DocumentWindow)myEditor.getDocument()).getDelegate();
            myFile = PsiDocumentManager.getInstance((Project)LightPlatformCodeInsightTestCase.getProject()).getPsiFile(document2);
            myEditor = ((EditorWindow)myEditor).getDelegate();
            myVFile = myFile.getVirtualFile();
        }
    }

    protected void caretRight() {
        LightPlatformCodeInsightTestCase.caretRight(LightPlatformCodeInsightTestCase.getEditor());
    }

    public static void caretRight(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "caretRight"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorRight", editor);
    }

    protected void caretUp() {
        LightPlatformCodeInsightTestCase.caretUp(LightPlatformCodeInsightTestCase.getEditor());
    }

    public static void caretUp(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "caretUp"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorUp", editor);
    }

    protected void deleteLine() {
        LightPlatformCodeInsightTestCase.deleteLine(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void deleteLine(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "deleteLine"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteLine", editor, project2);
    }

    protected void type(@NonNls @NotNull String s) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "type"));
        }
        for (char c : s.toCharArray()) {
            this.type(c);
        }
    }

    protected void type(char c) {
        LightPlatformCodeInsightTestCase.type(c, LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void type(char c, @NotNull Editor editor, Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "type"));
        }
        if (c == '\n') {
            LightPlatformCodeInsightTestCase.executeAction("EditorEnter", editor, project2);
        } else {
            EditorActionManager actionManager = EditorActionManager.getInstance();
            DataContext dataContext = DataManager.getInstance().getDataContext();
            TypedAction action = actionManager.getTypedAction();
            action.actionPerformed(editor, c, dataContext);
        }
    }

    protected void backspace() {
        LightPlatformCodeInsightTestCase.backspace(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void backspace(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "backspace"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorBackSpace", editor, project2);
    }

    protected void ctrlShiftF7() {
        HighlightUsagesHandler.invoke(LightPlatformCodeInsightTestCase.getProject(), LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getFile());
    }

    protected void ctrlW() {
        LightPlatformCodeInsightTestCase.ctrlW(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void ctrlW(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "ctrlW"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorSelectWord", editor, project2);
    }

    public void ctrlD() {
        LightPlatformCodeInsightTestCase.ctrlD(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void ctrlD(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "ctrlD"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorDuplicate", editor, project2);
    }

    protected void delete() {
        LightPlatformCodeInsightTestCase.delete(LightPlatformCodeInsightTestCase.getEditor(), LightPlatformCodeInsightTestCase.getProject());
    }

    public static void delete(@NotNull Editor editor, Project project2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "delete"));
        }
        LightPlatformCodeInsightTestCase.executeAction("EditorDelete", editor, project2);
    }

    protected static void home() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineStart");
    }

    protected static void end() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineEnd");
    }

    protected static void homeWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineStartWithSelection");
    }

    protected static void endWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLineEndWithSelection");
    }

    protected static void copy() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCopy");
    }

    protected static void paste() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPaste");
    }

    protected static void moveCaretToPreviousWordWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPreviousWordWithSelection");
    }

    protected static void moveCaretToNextWordWithSelection() {
        LightPlatformCodeInsightTestCase.executeAction("EditorNextWordWithSelection");
    }

    protected static void previousWord() {
        LightPlatformCodeInsightTestCase.executeAction("EditorPreviousWord");
    }

    protected static void nextWord() {
        LightPlatformCodeInsightTestCase.executeAction("EditorNextWord");
    }

    protected static void cutLineBackward() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCutLineBackward");
    }

    protected static void cutToLineEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorCutLineEnd");
    }

    protected static void deleteToLineStart() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteToLineStart");
    }

    protected static void deleteToLineEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDeleteToLineEnd");
    }

    protected static void killToWordStart() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillToWordStart");
    }

    protected static void killToWordEnd() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillToWordEnd");
    }

    protected static void killRegion() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillRegion");
    }

    protected static void killRingSave() {
        LightPlatformCodeInsightTestCase.executeAction("EditorKillRingSave");
    }

    protected static void unindent() {
        LightPlatformCodeInsightTestCase.executeAction("EditorUnindentSelection");
    }

    protected static void selectLine() {
        LightPlatformCodeInsightTestCase.executeAction("EditorSelectLine");
    }

    protected static void left() {
        LightPlatformCodeInsightTestCase.executeAction("EditorLeft");
    }

    protected static void right() {
        LightPlatformCodeInsightTestCase.executeAction("EditorRight");
    }

    protected static void up() {
        LightPlatformCodeInsightTestCase.executeAction("EditorUp");
    }

    protected static void down() {
        LightPlatformCodeInsightTestCase.executeAction("EditorDown");
    }

    protected static void lineComment() {
        new CommentByLineCommentAction().actionPerformedImpl(LightPlatformCodeInsightTestCase.getProject(), LightPlatformCodeInsightTestCase.getEditor());
    }

    protected static void executeAction(@NonNls @NotNull String actionId) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "executeAction"));
        }
        LightPlatformCodeInsightTestCase.executeAction(actionId, LightPlatformCodeInsightTestCase.getEditor());
    }

    protected static void executeAction(@NonNls @NotNull String actionId, @NotNull Editor editor) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "executeAction"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "executeAction"));
        }
        LightPlatformCodeInsightTestCase.executeAction(actionId, editor, LightPlatformCodeInsightTestCase.getProject());
    }

    public static void executeAction(@NonNls @NotNull String actionId, @NotNull Editor editor, Project project2) {
        if (actionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "executeAction"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "executeAction"));
        }
        CommandProcessor.getInstance().executeCommand(project2, () -> {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$executeAction$4"));
            }
            if (actionId == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionId", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$executeAction$4"));
            }
            EditorTestUtil.executeAction(editor, actionId);
        }, "", null, editor.getDocument());
    }

    @NotNull
    protected static DataContext getCurrentEditorDataContext() {
        DataContext defaultContext = DataManager.getInstance().getDataContext();
        DataContext dataContext = dataId -> {
            if (CommonDataKeys.EDITOR.is(dataId)) {
                return LightPlatformCodeInsightTestCase.getEditor();
            }
            if (CommonDataKeys.PROJECT.is(dataId)) {
                return LightPlatformCodeInsightTestCase.getProject();
            }
            if (CommonDataKeys.PSI_FILE.is(dataId)) {
                return LightPlatformCodeInsightTestCase.getFile();
            }
            if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                PsiFile file2 = LightPlatformCodeInsightTestCase.getFile();
                if (file2 == null) {
                    return null;
                }
                Editor editor = LightPlatformCodeInsightTestCase.getEditor();
                if (editor == null) {
                    return null;
                }
                return file2.findElementAt(editor.getCaretModel().getOffset());
            }
            return defaultContext.getData(dataId);
        };
        if (dataContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "getCurrentEditorDataContext"));
        }
        return dataContext;
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params() throws Throwable {
        return Collections.emptyList();
    }

    @Parameterized.Parameters(name="{0}")
    public static List<Object[]> params(@NotNull Class<?> klass) throws Throwable {
        if (klass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "klass", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "params"));
        }
        LightPlatformCodeInsightTestCase testCase = (LightPlatformCodeInsightTestCase)((Object)klass.newInstance());
        if (!(testCase instanceof FileBasedTestCaseHelper)) {
            LightPlatformCodeInsightTestCase.fail((String)"Parameterized test should implement FileBasedTestCaseHelper");
        }
        try {
            PathManagerEx.replaceLookupStrategy(klass, Parameterized.class);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FileBasedTestCaseHelper fileBasedTestCase = (FileBasedTestCaseHelper)((Object)testCase);
        String testDataPath = testCase.getTestDataPath();
        File testDir = null;
        if (fileBasedTestCase instanceof FileBasedTestCaseHelperEx) {
            testDir = new File(testDataPath, ((FileBasedTestCaseHelperEx)fileBasedTestCase).getRelativeBasePath());
        } else {
            TestDataPath annotation = klass.getAnnotation(TestDataPath.class);
            if (annotation == null) {
                LightPlatformCodeInsightTestCase.fail((String)"TestCase should implement com.intellij.testFramework.FileBasedTestCaseHelperEx or be annotated with com.intellij.testFramework.TestDataPath");
            } else {
                String trimmedRoot = StringUtil.trimStart((String)StringUtil.trimStart((String)annotation.value(), (String)"$CONTENT_ROOT"), (String)"$PROJECT_ROOT");
                String lastPathComponent = new File(testDataPath).getName();
                int idx = trimmedRoot.indexOf(lastPathComponent);
                testDataPath = testDataPath.replace(File.separatorChar, '/') + (idx > 0 ? trimmedRoot.substring(idx + lastPathComponent.length()) : trimmedRoot);
                testDir = new File(testDataPath);
            }
        }
        File[] files = testDir.listFiles();
        if (files == null) {
            LightPlatformCodeInsightTestCase.fail((String)("Test files not found in " + testDir.getPath()));
        }
        ArrayList<Object[]> result2 = new ArrayList<Object[]>();
        for (File file2 : files) {
            String fileSuffix = fileBasedTestCase.getFileSuffix(file2.getName());
            if (fileSuffix == null) continue;
            result2.add(new Object[]{fileSuffix, testDataPath});
        }
        return result2;
    }

    public String getName() {
        if (this.myFileSuffix != null) {
            return "test" + this.myFileSuffix;
        }
        return super.getName();
    }

    @Before
    public void before() throws Throwable {
        Throwable[] throwables = new Throwable[1];
        this.invokeTestRunnable(() -> {
            try {
                this.setUp();
            }
            catch (Throwable e) {
                throwables[0] = e;
            }
        });
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    @After
    public void after() throws Throwable {
        Throwable[] throwables = new Throwable[1];
        this.invokeTestRunnable(() -> {
            try {
                this.tearDown();
            }
            catch (Throwable e) {
                throwables[0] = e;
            }
        });
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }

    protected void runSingleTest(@NotNull Runnable testRunnable) throws Throwable {
        if (testRunnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testRunnable", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "runSingleTest"));
        }
        Throwable[] throwables = new Throwable[1];
        Runnable runnable2 = () -> {
            if (testRunnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testRunnable", "com/intellij/testFramework/LightPlatformCodeInsightTestCase", "lambda$runSingleTest$8"));
            }
            try {
                testRunnable.run();
            }
            catch (Throwable e) {
                throwables[0] = e;
            }
        };
        this.invokeTestRunnable(runnable2);
        if (throwables[0] != null) {
            throw throwables[0];
        }
    }
}

