/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class CompletionTester {
    private final CodeInsightTestFixture myFixture;

    public CompletionTester(@NotNull CodeInsightTestFixture fixture) {
        if (fixture == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fixture", "com/intellij/testFramework/fixtures/CompletionTester", "<init>"));
        }
        this.myFixture = fixture;
    }

    public void configure(String ... files) throws IOException {
        this.myFixture.configureByFiles(files);
    }

    protected String getDelimiter() {
        return "---";
    }

    public void doTestVariantsInner(String fileName, FileType fileType) throws Throwable {
        String fullFileName = this.myFixture.getTestDataPath() + File.separator + fileName;
        String content = FileUtil.loadFile((File)new File(fullFileName));
        int index = content.indexOf(this.getDelimiter());
        assert (index > 0);
        String testFileContent = content.substring(0, index);
        String expectedDataContent = content.substring(index + this.getDelimiter().length());
        this.myFixture.configureByText(fileType, testFileContent);
        Scanner in = new Scanner(expectedDataContent);
        CompletionType type = CompletionType.valueOf((String)in.next());
        int count = in.nextInt();
        CheckType checkType = CheckType.valueOf(in.next());
        in.useDelimiter("\n");
        ArrayList<String> variants = new ArrayList<String>();
        while (in.hasNext()) {
            String variant = in.next().trim();
            if (variant.length() <= 0) continue;
            variants.add(variant);
        }
        this.myFixture.complete(type, count);
        List<String> stringList = this.myFixture.getLookupElementStrings();
        if (stringList == null) {
            stringList = Collections.emptyList();
        }
        if (checkType == CheckType.EQUALS) {
            UsefulTestCase.assertOrderedEquals(stringList, variants);
        } else if (checkType == CheckType.INCLUDES) {
            variants.removeAll(stringList);
            Assert.assertTrue((String)("Missing variants: " + variants), (boolean)variants.isEmpty());
        } else if (checkType == CheckType.EXCLUDES) {
            variants.retainAll(stringList);
            Assert.assertTrue((String)("Unexpected variants: " + variants), (boolean)variants.isEmpty());
        }
    }

    static enum CheckType {
        EQUALS,
        INCLUDES,
        EXCLUDES;

    }
}

