/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class DialogButtonGroup
extends JPanel {
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    private int myPreferredH = 0;
    private int myPreferredW = 0;

    public DialogButtonGroup() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogButtonGroup.this.upPressed();
            }
        }, KeyStroke.getKeyStroke(38, 0), 1);
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogButtonGroup.this.downPressed();
            }
        }, KeyStroke.getKeyStroke(40, 0), 1);
    }

    public void addButton(AbstractButton button) {
        this.addButton(button, 2);
    }

    public void addButton(AbstractButton button, int position) {
        if (1 == position) {
            this.add((Component)button, 0);
            this.add(Box.createVerticalStrut(5), 1);
        } else {
            this.add(Box.createVerticalStrut(5));
            this.add(button);
        }
        Dimension prefSize = button.getPreferredSize();
        if (prefSize.height > this.myPreferredH) {
            this.myPreferredH = prefSize.height;
        }
        if (prefSize.width > this.myPreferredW) {
            this.myPreferredW = prefSize.width;
        }
        this.updateButtonSizes();
    }

    public void remove(AbstractButton button) {
        super.remove(button);
        this.updateButtonSizes();
    }

    @Override
    public void grabFocus() {
        ((JComponent)this.getComponent(0)).grabFocus();
    }

    private void updateButtonSizes() {
        Dimension dim = new Dimension(this.myPreferredW, this.myPreferredH);
        Component[] components = this.getComponents();
        if (components == null) {
            return;
        }
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)components[i];
            button.setPreferredSize(dim);
            button.setMaximumSize(dim);
            button.setMinimumSize(dim);
        }
    }

    private void upPressed() {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].hasFocus()) continue;
            if (i == 0) {
                components[components.length - 1].requestFocus();
                return;
            }
            components[i - 1].requestFocus();
            return;
        }
    }

    private void downPressed() {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].hasFocus()) continue;
            if (i == components.length - 1) {
                components[0].requestFocus();
                return;
            }
            components[i + 1].requestFocus();
            return;
        }
    }
}

