/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Expirable;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.TransferToEDTQueue;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.ide.PooledThreadExecutor;

abstract class Invoker
implements Disposable {
    private static final Logger LOG = Logger.getInstance(Invoker.class);
    private static final AtomicInteger UID = new AtomicInteger();
    private final AtomicInteger count = new AtomicInteger();
    private final String description;
    volatile boolean disposed;

    private Invoker(String prefix, String name) {
        this.description = "Invoker." + prefix + ":" + name + " " + UID.getAndIncrement();
    }

    public String toString() {
        return this.description;
    }

    public void dispose() {
        this.disposed = true;
    }

    public abstract boolean isValidThread();

    public final void invokeLater(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/ui/tree/Invoker", "invokeLater"));
        }
        if (this.canInvoke(task)) {
            this.count.incrementAndGet();
            this.offer(() -> {
                if (task == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/ui/tree/Invoker", "lambda$invokeLater$0"));
                }
                this.invokeSafely(task);
            });
        }
    }

    public final void invokeLaterIfNeeded(@NotNull Runnable task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/ui/tree/Invoker", "invokeLaterIfNeeded"));
        }
        if (this.isValidThread()) {
            this.count.incrementAndGet();
            this.invokeSafely(task);
        } else {
            this.invokeLater(task);
        }
    }

    public final int getTaskCount() {
        return this.disposed ? 0 : this.count.get();
    }

    abstract void offer(Runnable var1);

    final void invokeSafely(Runnable task) {
        try {
            if (this.canInvoke(task)) {
                task.run();
            }
        }
        catch (Exception exception) {
            LOG.warn((Throwable)exception);
        }
        finally {
            this.count.decrementAndGet();
        }
    }

    final boolean canInvoke(Runnable task) {
        Expirable expirable;
        if (this.disposed) {
            LOG.debug("Invoker is disposed");
            return false;
        }
        if (task instanceof Expirable && (expirable = (Expirable)task).isExpired()) {
            LOG.debug("Task is expired");
            return false;
        }
        return true;
    }

    public static class BackgroundQueue
    extends Invoker {
        private final QueueProcessor<Runnable> queue;

        public BackgroundQueue(@NotNull @NonNls String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/tree/Invoker$BackgroundQueue", "<init>"));
            }
            super("Background", name);
            this.queue = QueueProcessor.createRunnableQueueProcessor();
        }

        @Override
        public void dispose() {
            super.dispose();
            this.queue.clear();
        }

        @Override
        public boolean isValidThread() {
            return false;
        }

        @Override
        void offer(Runnable runnable2) {
            this.queue.add((Object)runnable2);
        }
    }

    public static class Background
    extends Invoker {
        public Background(@NotNull @NonNls String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/tree/Invoker$Background", "<init>"));
            }
            super("Background", name);
        }

        @Override
        public boolean isValidThread() {
            return !SwingUtilities.isEventDispatchThread();
        }

        @Override
        void offer(Runnable runnable2) {
            Application application = ApplicationManager.getApplication();
            if (application != null) {
                application.executeOnPooledThread(runnable2);
            } else {
                PooledThreadExecutor.INSTANCE.submit(runnable2);
            }
        }
    }

    public static class EDT
    extends Invoker {
        private final TransferToEDTQueue<Runnable> queue;

        public EDT(@NotNull @NonNls String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/tree/Invoker$EDT", "<init>"));
            }
            this(name, 200);
        }

        public EDT(@NotNull @NonNls String name, int maxUnitOfWorkThresholdMs) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/ui/tree/Invoker$EDT", "<init>"));
            }
            super("EDT", name);
            this.queue = TransferToEDTQueue.createRunnableMerger((String)this.toString(), (int)maxUnitOfWorkThresholdMs);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.queue.stop();
        }

        @Override
        public boolean isValidThread() {
            return SwingUtilities.isEventDispatchThread();
        }

        @Override
        void offer(Runnable runnable2) {
            this.queue.offer((Object)runnable2);
        }
    }
}

