/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.ui.EditorTextField;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Robot;
import java.awt.Window;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IJSwingUtilities
extends JBSwingUtilities {
    public static boolean hasFocus(Component component) {
        Component focusOwner = IJSwingUtilities.findFocusOwner(component);
        return focusOwner != null;
    }

    private static Component findFocusOwner(Component c) {
        Component focusOwner;
        Component temp = focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        while (temp != null) {
            if (temp == c) {
                return focusOwner;
            }
            temp = temp instanceof Window ? null : temp.getParent();
        }
        return null;
    }

    public static boolean hasFocus2(Component component) {
        WindowManagerEx windowManager = WindowManagerEx.getInstanceEx();
        Window activeWindow = null;
        if (windowManager != null) {
            activeWindow = windowManager.getMostRecentFocusedWindow();
        }
        if (activeWindow == null) {
            return false;
        }
        Component focusedComponent = windowManager.getFocusedComponent(activeWindow);
        if (focusedComponent == null) {
            return false;
        }
        return SwingUtilities.isDescendingFrom(focusedComponent, component);
    }

    public static int findDisplayedMnemonicIndex(String text, int mnemonic) {
        if (text == null || mnemonic == 0) {
            return -1;
        }
        char uc = Character.toUpperCase((char)mnemonic);
        char lc = Character.toLowerCase((char)mnemonic);
        int uci = text.indexOf(uc);
        int lci = text.indexOf(lc);
        if (uci == -1) {
            return lci;
        }
        if (lci == -1) {
            return uci;
        }
        return lci < uci ? lci : uci;
    }

    public static void adjustComponentsOnMac(@Nullable JComponent component) {
        IJSwingUtilities.adjustComponentsOnMac(null, component);
    }

    public static void adjustComponentsOnMac(@Nullable JLabel label, @Nullable JComponent component) {
        if (component == null) {
            return;
        }
        if (!UIUtil.isUnderAquaLookAndFeel()) {
            return;
        }
        if (component instanceof JComboBox) {
            UIUtil.addInsets((JComponent)component, (Insets)new Insets(0, -2, 0, 0));
            if (label != null) {
                UIUtil.addInsets((JComponent)label, (Insets)new Insets(0, 2, 0, 0));
            }
        }
        if (component instanceof JCheckBox) {
            UIUtil.addInsets((JComponent)component, (Insets)new Insets(0, -5, 0, 0));
        }
        if ((component instanceof JTextField || component instanceof EditorTextField) && label != null) {
            UIUtil.addInsets((JComponent)label, (Insets)new Insets(0, 3, 0, 0));
        }
    }

    public static HyperlinkEvent createHyperlinkEvent(@Nullable String href, @NotNull Object source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "source", "com/intellij/util/IJSwingUtilities", "createHyperlinkEvent"));
        }
        URL url = null;
        try {
            url = new URL(href);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return new HyperlinkEvent(source, HyperlinkEvent.EventType.ACTIVATED, url, href);
    }

    public static void updateComponentTreeUI(@Nullable Component c) {
        if (c == null) {
            return;
        }
        for (Component component : UIUtil.uiTraverser((Component)c).postOrderDfsTraversal()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).updateUI();
        }
        c.invalidate();
        c.validate();
        c.repaint();
    }

    public static void moveMousePointerOn(Component component) {
        if (component != null && component.isShowing()) {
            UISettings settings;
            UISettings uISettings = settings = ApplicationManager.getApplication() == null ? null : UISettings.getInstance();
            if (settings != null && settings.MOVE_MOUSE_ON_DEFAULT_BUTTON) {
                Point point = component.getLocationOnScreen();
                int dx = component.getWidth() / 2;
                int dy = component.getHeight() / 2;
                try {
                    new Robot().mouseMove(point.x + dx, point.y + dy);
                }
                catch (AWTException aWTException) {
                    // empty catch block
                }
            }
        }
    }
}

