/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.continuation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.TimeoutUtil;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModalityIgnorantBackgroundableTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.continuation.ModalityIgnorantBackgroundableTask");
    private Consumer<Task.Backgroundable> myRunner;
    private int myCnt;

    public ModalityIgnorantBackgroundableTask(@Nullable Project project2, @NotNull String title, boolean canBeCancelled, @Nullable PerformInBackgroundOption backgroundOption) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/continuation/ModalityIgnorantBackgroundableTask", "<init>"));
        }
        super(project2, title, canBeCancelled, backgroundOption);
    }

    public ModalityIgnorantBackgroundableTask(@Nullable Project project2, @NotNull String title, boolean canBeCancelled) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/continuation/ModalityIgnorantBackgroundableTask", "<init>"));
        }
        super(project2, title, canBeCancelled);
    }

    public ModalityIgnorantBackgroundableTask(@Nullable Project project2, @NotNull String title) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/util/continuation/ModalityIgnorantBackgroundableTask", "<init>"));
        }
        super(project2, title);
    }

    protected abstract void doInAwtIfFail(Exception var1);

    protected abstract void doInAwtIfCancel();

    protected abstract void doInAwtIfSuccess();

    protected abstract void runImpl(@NotNull ProgressIndicator var1);

    public void runSteadily(Consumer<Task.Backgroundable> consumer) {
        this.myRunner = consumer;
        this.myCnt = 100;
        consumer.consume((Object)this);
    }

    public void run(final @NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/continuation/ModalityIgnorantBackgroundableTask", "run"));
        }
        try {
            this.runImpl(indicator);
        }
        catch (ToBeRepeatedException tbre) {
            if (this.myRunner != null && this.myCnt > 0) {
                --this.myCnt;
                TimeoutUtil.sleep((long)100L);
                this.myRunner.consume((Object)this);
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModalityIgnorantBackgroundableTask.this.doInAwtIfFail(tbre);
                }
            });
        }
        catch (Exception e) {
            LOG.info((Throwable)e);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModalityIgnorantBackgroundableTask.this.doInAwtIfFail(e);
                }
            });
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (indicator.isCanceled()) {
                    ModalityIgnorantBackgroundableTask.this.doInAwtIfCancel();
                } else {
                    ModalityIgnorantBackgroundableTask.this.doInAwtIfSuccess();
                }
            }
        });
    }

    public static class ToBeRepeatedException
    extends RuntimeException {
    }
}

