/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakInterner;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.impl.AbstractDomChildDescriptionImpl;
import com.intellij.util.xml.impl.AttributeChildDescriptionImpl;
import com.intellij.util.xml.impl.ChildrenDescriptionsHolder;
import com.intellij.util.xml.impl.CollectionChildDescriptionImpl;
import com.intellij.util.xml.impl.CustomDomChildrenDescriptionImpl;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomGenericInfoEx;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.FixedChildDescriptionImpl;
import com.intellij.util.xml.impl.Invocation;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.reflect.AbstractDomChildrenDescription;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtenderEP;
import com.intellij.util.xml.reflect.DomExtensionImpl;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.intellij.util.xml.reflect.DomExtensionsRegistrarImpl;
import com.intellij.util.xml.reflect.DomFixedChildDescription;
import gnu.trove.THashSet;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DynamicGenericInfo
extends DomGenericInfoEx {
    private static final Key<SoftReference<WeakInterner<ChildrenDescriptionsHolder>>> HOLDERS_CACHE = Key.create((String)"DOM_CHILDREN_HOLDERS_CACHE");
    private static final RecursionGuard ourGuard = RecursionManager.createGuard((String)"dynamicGenericInfo");
    private final StaticGenericInfo myStaticGenericInfo;
    @NotNull
    private final DomInvocationHandler myInvocationHandler;
    private volatile boolean myInitialized;
    private volatile ChildrenDescriptionsHolder<AttributeChildDescriptionImpl> myAttributes;
    private volatile ChildrenDescriptionsHolder<FixedChildDescriptionImpl> myFixeds;
    private volatile ChildrenDescriptionsHolder<CollectionChildDescriptionImpl> myCollections;
    private volatile List<CustomDomChildrenDescriptionImpl> myCustomChildren;

    public DynamicGenericInfo(@NotNull DomInvocationHandler handler2, StaticGenericInfo staticGenericInfo) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/util/xml/impl/DynamicGenericInfo", "<init>"));
        }
        this.myInvocationHandler = handler2;
        this.myStaticGenericInfo = staticGenericInfo;
        this.myAttributes = staticGenericInfo.getAttributes();
        this.myFixeds = staticGenericInfo.getFixed();
        this.myCollections = staticGenericInfo.getCollections();
    }

    @Override
    public Invocation createInvocation(JavaMethod method) {
        return this.myStaticGenericInfo.createInvocation(method);
    }

    @Override
    public final boolean checkInitialized() {
        if (this.myInitialized) {
            return true;
        }
        this.myStaticGenericInfo.buildMethodMaps();
        if (!this.myInvocationHandler.exists()) {
            return true;
        }
        return ourGuard.doPreventingRecursion((Object)this.myInvocationHandler, false, () -> {
            DomExtensionsRegistrarImpl registrar = this.runDomExtenders();
            DomInvocationHandler domInvocationHandler = this.myInvocationHandler;
            synchronized (domInvocationHandler) {
                if (!this.myInitialized) {
                    if (registrar != null) {
                        this.applyExtensions(registrar);
                    }
                    this.myInitialized = true;
                }
            }
            return Boolean.TRUE;
        }) == Boolean.TRUE;
    }

    private void applyExtensions(DomExtensionsRegistrarImpl registrar) {
        List<DomExtensionImpl> customs;
        XmlFile file2 = this.myInvocationHandler.getFile();
        List<DomExtensionImpl> fixeds = registrar.getFixeds();
        List<DomExtensionImpl> collections = registrar.getCollections();
        List<DomExtensionImpl> attributes = registrar.getAttributes();
        if (!attributes.isEmpty()) {
            ChildrenDescriptionsHolder<AttributeChildDescriptionImpl> newAttributes = new ChildrenDescriptionsHolder<AttributeChildDescriptionImpl>(this.myStaticGenericInfo.getAttributes());
            for (DomExtensionImpl extension2 : attributes) {
                newAttributes.addDescription(extension2.addAnnotations(new AttributeChildDescriptionImpl(extension2.getXmlName(), extension2.getType())));
            }
            this.myAttributes = DynamicGenericInfo.internChildrenHolder(file2, newAttributes);
        }
        if (!fixeds.isEmpty()) {
            ChildrenDescriptionsHolder<FixedChildDescriptionImpl> newFixeds = new ChildrenDescriptionsHolder<FixedChildDescriptionImpl>(this.myStaticGenericInfo.getFixed());
            for (DomExtensionImpl extension2 : fixeds) {
                newFixeds.addDescription(extension2.addAnnotations(new FixedChildDescriptionImpl(extension2.getXmlName(), extension2.getType(), extension2.getCount(), ArrayUtil.EMPTY_COLLECTION_ARRAY)));
            }
            this.myFixeds = DynamicGenericInfo.internChildrenHolder(file2, newFixeds);
        }
        if (!collections.isEmpty()) {
            ChildrenDescriptionsHolder<CollectionChildDescriptionImpl> newCollections = new ChildrenDescriptionsHolder<CollectionChildDescriptionImpl>(this.myStaticGenericInfo.getCollections());
            for (DomExtensionImpl extension2 : collections) {
                newCollections.addDescription(extension2.addAnnotations(new CollectionChildDescriptionImpl(extension2.getXmlName(), extension2.getType(), Collections.emptyList())));
            }
            this.myCollections = DynamicGenericInfo.internChildrenHolder(file2, newCollections);
        }
        this.myCustomChildren = (customs = registrar.getCustoms()).isEmpty() ? null : ContainerUtil.map(customs, extension -> new CustomDomChildrenDescriptionImpl((DomExtensionImpl)extension));
    }

    private static <T extends DomChildDescriptionImpl> ChildrenDescriptionsHolder<T> internChildrenHolder(XmlFile file2, ChildrenDescriptionsHolder<T> holder) {
        SoftReference ref = (SoftReference)file2.getUserData(HOLDERS_CACHE);
        WeakInterner cache = (WeakInterner)SoftReference.dereference((Reference)ref);
        if (cache == null) {
            cache = new WeakInterner();
            file2.putUserData(HOLDERS_CACHE, (Object)new SoftReference((Object)cache));
        }
        return (ChildrenDescriptionsHolder)cache.intern(holder);
    }

    @Nullable
    private DomExtensionsRegistrarImpl runDomExtenders() {
        List<DomExtender> extendersFromParent;
        AbstractDomChildrenDescription description;
        DomExtensionsRegistrarImpl registrar = null;
        Project project2 = this.myInvocationHandler.getManager().getProject();
        DomExtenderEP[] extenders = (DomExtenderEP[])Extensions.getExtensions(DomExtenderEP.EP_NAME);
        if (extenders.length > 0) {
            for (DomExtenderEP extenderEP : extenders) {
                registrar = extenderEP.extend(project2, this.myInvocationHandler, registrar);
            }
        }
        if ((description = this.myInvocationHandler.getChildDescription()) != null && (extendersFromParent = description.getUserData(DomExtensionImpl.DOM_EXTENDER_KEY)) != null) {
            if (registrar == null) {
                registrar = new DomExtensionsRegistrarImpl();
            }
            for (DomExtender extender : extendersFromParent) {
                extender.registerExtensions(this.myInvocationHandler.getProxy(), (DomExtensionsRegistrar)registrar);
            }
        }
        return registrar;
    }

    public XmlElement getNameElement(DomElement element) {
        return this.myStaticGenericInfo.getNameElement(element);
    }

    public GenericDomValue getNameDomElement(DomElement element) {
        return this.myStaticGenericInfo.getNameDomElement(element);
    }

    @NotNull
    public List<? extends CustomDomChildrenDescription> getCustomNameChildrenDescription() {
        this.checkInitialized();
        if (this.myCustomChildren != null) {
            List<CustomDomChildrenDescriptionImpl> list = this.myCustomChildren;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DynamicGenericInfo", "getCustomNameChildrenDescription"));
            }
            return list;
        }
        List<? extends CustomDomChildrenDescriptionImpl> list = this.myStaticGenericInfo.getCustomNameChildrenDescription();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DynamicGenericInfo", "getCustomNameChildrenDescription"));
        }
        return list;
    }

    public String getElementName(DomElement element) {
        return this.myStaticGenericInfo.getElementName(element);
    }

    @NotNull
    public List<AbstractDomChildDescriptionImpl> getChildrenDescriptions() {
        this.checkInitialized();
        ArrayList<AbstractDomChildDescriptionImpl> list = new ArrayList<AbstractDomChildDescriptionImpl>();
        this.myAttributes.dumpDescriptions(list);
        this.myFixeds.dumpDescriptions(list);
        this.myCollections.dumpDescriptions(list);
        list.addAll(this.myStaticGenericInfo.getCustomNameChildrenDescription());
        ArrayList<AbstractDomChildDescriptionImpl> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DynamicGenericInfo", "getChildrenDescriptions"));
        }
        return arrayList;
    }

    @NotNull
    public final List<FixedChildDescriptionImpl> getFixedChildrenDescriptions() {
        this.checkInitialized();
        List<FixedChildDescriptionImpl> list = this.myFixeds.getDescriptions();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DynamicGenericInfo", "getFixedChildrenDescriptions"));
        }
        return list;
    }

    @NotNull
    public final List<CollectionChildDescriptionImpl> getCollectionChildrenDescriptions() {
        this.checkInitialized();
        List<CollectionChildDescriptionImpl> list = this.myCollections.getDescriptions();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DynamicGenericInfo", "getCollectionChildrenDescriptions"));
        }
        return list;
    }

    public FixedChildDescriptionImpl getFixedChildDescription(String tagName) {
        this.checkInitialized();
        return this.myFixeds.findDescription(tagName);
    }

    public DomFixedChildDescription getFixedChildDescription(@NonNls String tagName, @NonNls String namespace) {
        this.checkInitialized();
        return this.myFixeds.getDescription(tagName, namespace);
    }

    public CollectionChildDescriptionImpl getCollectionChildDescription(String tagName) {
        this.checkInitialized();
        return this.myCollections.findDescription(tagName);
    }

    public DomCollectionChildDescription getCollectionChildDescription(@NonNls String tagName, @NonNls String namespace) {
        this.checkInitialized();
        return this.myCollections.getDescription(tagName, namespace);
    }

    public AttributeChildDescriptionImpl getAttributeChildDescription(String attributeName) {
        this.checkInitialized();
        return this.myAttributes.findDescription(attributeName);
    }

    public DomAttributeChildDescription getAttributeChildDescription(@NonNls String attributeName, @NonNls String namespace) {
        this.checkInitialized();
        return this.myAttributes.getDescription(attributeName, namespace);
    }

    public boolean isTagValueElement() {
        return this.myStaticGenericInfo.isTagValueElement();
    }

    @Override
    @NotNull
    public List<AttributeChildDescriptionImpl> getAttributeChildrenDescriptions() {
        this.checkInitialized();
        List<AttributeChildDescriptionImpl> list = this.myAttributes.getDescriptions();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/impl/DynamicGenericInfo", "getAttributeChildrenDescriptions"));
        }
        return list;
    }

    @Override
    public boolean processAttributeChildrenDescriptions(Processor<AttributeChildDescriptionImpl> processor2) {
        THashSet visited = new THashSet();
        if (!this.myStaticGenericInfo.processAttributeChildrenDescriptions((Processor<AttributeChildDescriptionImpl>)((Processor)arg_0 -> DynamicGenericInfo.lambda$processAttributeChildrenDescriptions$2((Set)visited, processor2, arg_0)))) {
            return false;
        }
        for (AttributeChildDescriptionImpl description : this.getAttributeChildrenDescriptions()) {
            if (visited.contains(description) || processor2.process((Object)description)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$processAttributeChildrenDescriptions$2(Set visited, Processor processor2, AttributeChildDescriptionImpl attributeChildDescription) {
        visited.add(attributeChildDescription);
        return processor2.process((Object)attributeChildDescription);
    }
}

