/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.BiDirectionalEnumerator;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogHashMap;
import gnu.trove.TObjectHashingStrategy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InMemoryHashMap
implements VcsLogHashMap {
    private final BiDirectionalEnumerator<CommitId> myEnumerator = new BiDirectionalEnumerator(1, TObjectHashingStrategy.CANONICAL);

    @Override
    public int getCommitIndex(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/InMemoryHashMap", "getCommitIndex"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/InMemoryHashMap", "getCommitIndex"));
        }
        return this.getOrPut(hash, root);
    }

    private int getOrPut(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/data/InMemoryHashMap", "getOrPut"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/data/InMemoryHashMap", "getOrPut"));
        }
        return this.myEnumerator.enumerate((Object)new CommitId(hash, root));
    }

    @Override
    @NotNull
    public CommitId getCommitId(int commitIndex) {
        CommitId commitId = (CommitId)this.myEnumerator.getValue(commitIndex);
        if (commitId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/data/InMemoryHashMap", "getCommitId"));
        }
        return commitId;
    }

    @Override
    @Nullable
    public CommitId findCommitId(@NotNull Condition<CommitId> condition) {
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/data/InMemoryHashMap", "findCommitId"));
        }
        CommitId[] result2 = new CommitId[]{null};
        this.myEnumerator.forEachValue(commitId -> {
            if (condition == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/vcs/log/data/InMemoryHashMap", "lambda$findCommitId$0"));
            }
            if (condition.value(commitId)) {
                result2[0] = commitId;
                return false;
            }
            return true;
        });
        return result2[0];
    }

    @Override
    public void flush() {
    }
}

