/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.permanent;

import com.intellij.vcs.log.graph.api.GraphLayout;
import com.intellij.vcs.log.graph.utils.IntList;
import com.intellij.vcs.log.graph.utils.impl.CompressedIntList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class GraphLayoutImpl
implements GraphLayout {
    @NotNull
    private final IntList myLayoutIndex;
    @NotNull
    private final List<Integer> myHeadNodeIndex;
    @NotNull
    private final int[] myStartLayoutIndexForHead;

    public GraphLayoutImpl(@NotNull int[] layoutIndex, @NotNull List<Integer> headNodeIndex, @NotNull int[] startLayoutIndexForHead) {
        if (layoutIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layoutIndex", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutImpl", "<init>"));
        }
        if (headNodeIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headNodeIndex", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutImpl", "<init>"));
        }
        if (startLayoutIndexForHead == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startLayoutIndexForHead", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutImpl", "<init>"));
        }
        this.myLayoutIndex = CompressedIntList.newInstance(layoutIndex);
        this.myHeadNodeIndex = headNodeIndex;
        this.myStartLayoutIndexForHead = startLayoutIndexForHead;
    }

    @Override
    public int getLayoutIndex(int nodeIndex) {
        return this.myLayoutIndex.get(nodeIndex);
    }

    @Override
    public int getOneOfHeadNodeIndex(int nodeIndex) {
        return this.getHeadNodeIndex(this.getLayoutIndex(nodeIndex));
    }

    public int getHeadNodeIndex(int layoutIndex) {
        return this.myHeadNodeIndex.get(this.getHeadOrder(layoutIndex));
    }

    @Override
    @NotNull
    public List<Integer> getHeadNodeIndex() {
        List<Integer> list = this.myHeadNodeIndex;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/permanent/GraphLayoutImpl", "getHeadNodeIndex"));
        }
        return list;
    }

    private int getHeadOrder(int layoutIndex) {
        int a = 0;
        int b = this.myStartLayoutIndexForHead.length - 1;
        while (b > a) {
            int middle = (a + b + 1) / 2;
            if (this.myStartLayoutIndexForHead[middle] <= layoutIndex) {
                a = middle;
                continue;
            }
            b = middle - 1;
        }
        return a;
    }
}

