/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.impl.print.elements;

import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.api.elements.GraphEdge;
import com.intellij.vcs.log.graph.api.elements.GraphEdgeType;
import com.intellij.vcs.log.graph.api.printer.PrintElementManager;
import com.intellij.vcs.log.graph.impl.print.elements.PrintElementWithGraphElement;
import org.jetbrains.annotations.NotNull;

public class EdgePrintElementImpl
extends PrintElementWithGraphElement
implements EdgePrintElement {
    @NotNull
    private final EdgePrintElement.Type myType;
    @NotNull
    private final EdgePrintElement.LineStyle myLineStyle;
    private final int myPositionInOtherRow;
    private final boolean myHasArrow;

    @NotNull
    public static EdgePrintElement.LineStyle convertToLineStyle(@NotNull GraphEdgeType edgeType) {
        if (edgeType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "edgeType", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "convertToLineStyle"));
        }
        switch (edgeType) {
            case USUAL: 
            case NOT_LOAD_COMMIT: {
                EdgePrintElement.LineStyle lineStyle = EdgePrintElement.LineStyle.SOLID;
                if (lineStyle == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "convertToLineStyle"));
                }
                return lineStyle;
            }
            case DOTTED: 
            case DOTTED_ARROW_UP: 
            case DOTTED_ARROW_DOWN: {
                EdgePrintElement.LineStyle lineStyle = EdgePrintElement.LineStyle.DASHED;
                if (lineStyle == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "convertToLineStyle"));
                }
                return lineStyle;
            }
        }
        throw new IllegalStateException("Edge type not supported: " + (Object)((Object)edgeType));
    }

    public EdgePrintElementImpl(int rowIndex, int positionInCurrentRow, int positionInOtherRow, @NotNull EdgePrintElement.Type type, @NotNull GraphEdge graphEdge, boolean hasArrow, @NotNull PrintElementManager printElementManager) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "<init>"));
        }
        if (graphEdge == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphEdge", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "<init>"));
        }
        if (printElementManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "printElementManager", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "<init>"));
        }
        super(rowIndex, positionInCurrentRow, graphEdge, printElementManager);
        this.myType = type;
        this.myLineStyle = EdgePrintElementImpl.convertToLineStyle(graphEdge.getType());
        this.myPositionInOtherRow = positionInOtherRow;
        this.myHasArrow = hasArrow;
    }

    public int getPositionInOtherRow() {
        return this.myPositionInOtherRow;
    }

    @NotNull
    public EdgePrintElement.Type getType() {
        EdgePrintElement.Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "getType"));
        }
        return type;
    }

    @NotNull
    public EdgePrintElement.LineStyle getLineStyle() {
        EdgePrintElement.LineStyle lineStyle = this.myLineStyle;
        if (lineStyle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/graph/impl/print/elements/EdgePrintElementImpl", "getLineStyle"));
        }
        return lineStyle;
    }

    public boolean hasArrow() {
        return this.myHasArrow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EdgePrintElement)) {
            return false;
        }
        EdgePrintElement that = (EdgePrintElement)o;
        if (this.myPositionInCurrentRow != that.getPositionInCurrentRow()) {
            return false;
        }
        if (this.myPositionInOtherRow != that.getPositionInOtherRow()) {
            return false;
        }
        if (this.myRowIndex != that.getRowIndex()) {
            return false;
        }
        if (this.myType != that.getType()) {
            return false;
        }
        return this.myHasArrow == that.hasArrow();
    }

    public int hashCode() {
        int result2 = this.myRowIndex;
        result2 = 31 * result2 + this.myPositionInCurrentRow;
        result2 = 31 * result2 + this.myPositionInOtherRow;
        result2 = 37 * result2 + this.myType.hashCode();
        result2 = 31 * result2 + (this.myHasArrow ? 1 : 0);
        return result2;
    }
}

