/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.AbstractApplicationUsagesCollector;
import com.intellij.internal.statistic.CollectUsagesException;
import com.intellij.internal.statistic.StatisticsUtilKt;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.impl.VcsProjectLog;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogRepoSizeCollector
extends AbstractApplicationUsagesCollector {
    public static final GroupDescriptor ID = GroupDescriptor.create("VCS Log 2");

    @Override
    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project2) throws CollectUsagesException {
        DataPack dataPack;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector", "getProjectUsages"));
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project2);
        VcsLogData logData = projectLog.getDataManager();
        if (logData != null && (dataPack = logData.getDataPack()).isFull()) {
            PermanentGraph<Integer> permanentGraph = dataPack.getPermanentGraph();
            MultiMap<VcsKey, VirtualFile> groupedRoots = VcsLogRepoSizeCollector.groupRootsByVcs(dataPack.getLogProviders());
            HashSet usages = ContainerUtil.newHashSet();
            usages.add(StatisticsUtilKt.getCountingUsage("data.commit.count", permanentGraph.getAllCommits().size(), Arrays.asList(0, 1, 100, 1000, 10000, 100000, 500000)));
            for (VcsKey vcs : groupedRoots.keySet()) {
                usages.add(StatisticsUtilKt.getCountingUsage("data." + vcs.getName().toLowerCase() + ".root.count", groupedRoots.get((Object)vcs).size(), Arrays.asList(0, 1, 2, 5, 8, 15, 30, 50, 100)));
            }
            HashSet hashSet = usages;
            if (hashSet == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector", "getProjectUsages"));
            }
            return hashSet;
        }
        Set<UsageDescriptor> set = Collections.emptySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector", "getProjectUsages"));
        }
        return set;
    }

    @NotNull
    private static MultiMap<VcsKey, VirtualFile> groupRootsByVcs(@NotNull Map<VirtualFile, VcsLogProvider> providers) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector", "groupRootsByVcs"));
        }
        MultiMap result2 = MultiMap.create();
        for (Map.Entry<VirtualFile, VcsLogProvider> entry : providers.entrySet()) {
            VirtualFile root = entry.getKey();
            VcsKey vcs = entry.getValue().getSupportedVcs();
            result2.putValue((Object)vcs, (Object)root);
        }
        MultiMap multiMap = result2;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector", "groupRootsByVcs"));
        }
        return multiMap;
    }

    @Override
    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = ID;
        if (groupDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/statistics/VcsLogRepoSizeCollector", "getGroupId"));
        }
        return groupDescriptor;
    }
}

