/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui;

import com.google.common.util.concurrent.SettableFuture;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NamedRunnable;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLog;
import com.intellij.vcs.log.VcsLogDataPack;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogFilterUi;
import com.intellij.vcs.log.VcsLogListener;
import com.intellij.vcs.log.VcsLogUi;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.data.VcsLogFilterer;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.data.VisiblePack;
import com.intellij.vcs.log.data.VisiblePackChangeListener;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.VcsLogImpl;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.frame.MainFrame;
import com.intellij.vcs.log.ui.frame.VcsLogGraphTable;
import com.intellij.vcs.log.ui.tables.GraphTableModel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class VcsLogUiImpl
implements VcsLogUi,
Disposable {
    private static final Logger LOG = Logger.getInstance(VcsLogUiImpl.class);
    public static final ExtensionPointName<VcsLogHighlighterFactory> LOG_HIGHLIGHTER_FACTORY_EP = ExtensionPointName.create((String)"com.intellij.logHighlighterFactory");
    @NotNull
    private final MainFrame myMainFrame;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final VcsLog myLog;
    @NotNull
    private final VcsLogUiProperties myUiProperties;
    @NotNull
    private final VcsLogFilterer myFilterer;
    @NotNull
    private final Collection<VcsLogListener> myLogListeners;
    private final VisiblePackChangeListener myVisiblePackChangeListener;
    @NotNull
    private VisiblePack myVisiblePack;

    public VcsLogUiImpl(@NotNull VcsLogData logData, @NotNull Project project2, @NotNull VcsLogColorManager manager, @NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogFilterer filterer) {
        if (logData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "logData", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        if (filterer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterer", "com/intellij/vcs/log/ui/VcsLogUiImpl", "<init>"));
        }
        this.myLogListeners = ContainerUtil.newArrayList();
        this.myProject = project2;
        this.myColorManager = manager;
        this.myUiProperties = uiProperties;
        Disposer.register((Disposable)logData, (Disposable)this);
        this.myFilterer = filterer;
        this.myLog = new VcsLogImpl(logData, this);
        this.myVisiblePack = VisiblePack.EMPTY;
        this.myMainFrame = new MainFrame(logData, this, project2, uiProperties, this.myLog, this.myVisiblePack);
        for (VcsLogHighlighterFactory factory : (VcsLogHighlighterFactory[])Extensions.getExtensions(LOG_HIGHLIGHTER_FACTORY_EP, (AreaInstance)this.myProject)) {
            this.getTable().addHighlighter(factory.createHighlighter(logData, this));
        }
        this.myVisiblePackChangeListener = visiblePack -> UIUtil.invokeLaterIfNeeded(() -> {
            if (!Disposer.isDisposed((Disposable)this)) {
                this.setVisiblePack(visiblePack);
            }
        });
        this.myFilterer.addVisiblePackChangeListener(this.myVisiblePackChangeListener);
    }

    public void requestFocus() {
        VcsLogGraphTable graphTable = this.myMainFrame.getGraphTable();
        if (graphTable.getRowCount() > 0) {
            IdeFocusManager.getInstance((Project)this.myProject).requestFocus((Component)((Object)graphTable), true).doWhenProcessed(() -> graphTable.setRowSelectionInterval(0, 0));
        }
    }

    public void setVisiblePack(@NotNull VisiblePack pack) {
        if (pack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pack", "com/intellij/vcs/log/ui/VcsLogUiImpl", "setVisiblePack"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean permGraphChanged = this.myVisiblePack.getDataPack() != pack.getDataPack();
        this.myVisiblePack = pack;
        this.myMainFrame.updateDataPack(this.myVisiblePack, permGraphChanged);
        this.setLongEdgeVisibility(this.myUiProperties.areLongEdgesVisible());
        this.fireFilterChangeEvent(this.myVisiblePack, permGraphChanged);
        this.repaintUI();
    }

    @NotNull
    public MainFrame getMainFrame() {
        MainFrame mainFrame = this.myMainFrame;
        if (mainFrame == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getMainFrame"));
        }
        return mainFrame;
    }

    public void repaintUI() {
        this.myMainFrame.getGraphTable().repaint();
    }

    private void performLongAction(@NotNull GraphAction graphAction, @NotNull String title) {
        if (graphAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphAction", "com/intellij/vcs/log/ui/VcsLogUiImpl", "performLongAction"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/vcs/log/ui/VcsLogUiImpl", "performLongAction"));
        }
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            if (graphAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "graphAction", "com/intellij/vcs/log/ui/VcsLogUiImpl", "lambda$performLongAction$4"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/vcs/log/ui/VcsLogUiImpl", "lambda$performLongAction$4"));
            }
            GraphAnswer answer = this.myVisiblePack.getVisibleGraph().getActionController().performAction(graphAction);
            Runnable updater = answer.getGraphUpdater();
            ApplicationManager.getApplication().invokeLater(() -> {
                if (title == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/vcs/log/ui/VcsLogUiImpl", "lambda$null$3"));
                }
                assert (updater != null) : "Action:" + title + "\nController: " + this.myVisiblePack.getVisibleGraph().getActionController() + "\nAnswer:" + answer;
                updater.run();
                this.getTable().handleAnswer((GraphAnswer<Integer>)answer, true, null, null);
            });
        }, title, false, null, this.getMainFrame().getMainComponent());
    }

    public void expandAll() {
        this.performLongAction((GraphAction)new GraphAction.GraphActionImpl(null, GraphAction.Type.BUTTON_EXPAND), "Expanding " + (this.getBekType() == PermanentGraph.SortType.LinearBek ? "merges..." : "linear branches..."));
    }

    public void collapseAll() {
        this.performLongAction((GraphAction)new GraphAction.GraphActionImpl(null, GraphAction.Type.BUTTON_COLLAPSE), "Collapsing " + (this.getBekType() == PermanentGraph.SortType.LinearBek ? "merges..." : "linear branches..."));
    }

    public void setLongEdgeVisibility(boolean visibility) {
        this.myVisiblePack.getVisibleGraph().getActionController().setLongEdgesHidden(!visibility);
        this.myUiProperties.setLongEdgesVisibility(visibility);
    }

    public boolean areLongEdgesVisible() {
        return this.myUiProperties.areLongEdgesVisible();
    }

    public void setBekType(@NotNull PermanentGraph.SortType bekType) {
        if (bekType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bekType", "com/intellij/vcs/log/ui/VcsLogUiImpl", "setBekType"));
        }
        this.myUiProperties.setBek(bekType.ordinal());
        this.myFilterer.onSortTypeChange(bekType);
    }

    @NotNull
    public PermanentGraph.SortType getBekType() {
        PermanentGraph.SortType sortType = PermanentGraph.SortType.values()[this.myUiProperties.getBekSortType()];
        if (sortType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getBekType"));
        }
        return sortType;
    }

    public void setShowRootNames(boolean isShowRootNames) {
        this.myUiProperties.setShowRootNames(isShowRootNames);
        this.myMainFrame.getGraphTable().rootColumnUpdated();
    }

    public boolean isShowRootNames() {
        return this.myUiProperties.isShowRootNames();
    }

    public boolean isHighlighterEnabled(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/ui/VcsLogUiImpl", "isHighlighterEnabled"));
        }
        return this.myUiProperties.isHighlighterEnabled(id);
    }

    public void setHighlighterEnabled(@NotNull String id, boolean enabled) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/vcs/log/ui/VcsLogUiImpl", "setHighlighterEnabled"));
        }
        this.myUiProperties.enableHighlighter(id, enabled);
        this.repaintUI();
    }

    public boolean areGraphActionsEnabled() {
        return this.myMainFrame.areGraphActionsEnabled();
    }

    public boolean isShowDetails() {
        return this.myUiProperties.isShowDetails();
    }

    public void setShowDetails(boolean showDetails) {
        this.myMainFrame.showDetails(showDetails);
        this.myUiProperties.setShowDetails(showDetails);
    }

    @NotNull
    public Future<Boolean> jumpToCommit(@NotNull Hash commitHash, @NotNull VirtualFile root) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpToCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpToCommit"));
        }
        SettableFuture future2 = SettableFuture.create();
        this.jumpTo(commitHash, (model, hash) -> {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/ui/VcsLogUiImpl", "lambda$jumpToCommit$5"));
            }
            return model.getRowOfCommit((Hash)hash, root);
        }, (SettableFuture<Boolean>)future2);
        SettableFuture settableFuture = future2;
        if (settableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpToCommit"));
        }
        return settableFuture;
    }

    @NotNull
    public Future<Boolean> jumpToCommitByPartOfHash(@NotNull String commitHash) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpToCommitByPartOfHash"));
        }
        SettableFuture future2 = SettableFuture.create();
        this.jumpTo(commitHash, (model, hash) -> model.getRowOfCommitByPartOfHash((String)hash), (SettableFuture<Boolean>)future2);
        SettableFuture settableFuture = future2;
        if (settableFuture == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpToCommitByPartOfHash"));
        }
        return settableFuture;
    }

    private <T> void jumpTo(@NotNull T commitId, @NotNull PairFunction<GraphTableModel, T, Integer> rowGetter, @NotNull SettableFuture<Boolean> future2) {
        if (commitId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpTo"));
        }
        if (rowGetter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowGetter", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpTo"));
        }
        if (future2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/vcs/log/ui/VcsLogUiImpl", "jumpTo"));
        }
        if (future2.isCancelled()) {
            return;
        }
        GraphTableModel model = this.getTable().getModel();
        int row = (Integer)rowGetter.fun((Object)model, commitId);
        if (row >= 0) {
            this.myMainFrame.getGraphTable().jumpToRow(row);
            future2.set((Object)true);
        } else if (model.canRequestMore()) {
            model.requestToLoadMore(() -> {
                if (commitId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/ui/VcsLogUiImpl", "lambda$jumpTo$7"));
                }
                if (rowGetter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowGetter", "com/intellij/vcs/log/ui/VcsLogUiImpl", "lambda$jumpTo$7"));
                }
                if (future2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/vcs/log/ui/VcsLogUiImpl", "lambda$jumpTo$7"));
                }
                this.jumpTo(commitId, rowGetter, future2);
            });
        } else if (!this.myVisiblePack.isFull()) {
            this.invokeOnChange(() -> {
                if (commitId == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitId", "com/intellij/vcs/log/ui/VcsLogUiImpl", "lambda$jumpTo$8"));
                }
                if (rowGetter == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rowGetter", "com/intellij/vcs/log/ui/VcsLogUiImpl", "lambda$jumpTo$8"));
                }
                if (future2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "future", "com/intellij/vcs/log/ui/VcsLogUiImpl", "lambda$jumpTo$8"));
                }
                this.jumpTo(commitId, rowGetter, future2);
            });
        } else {
            this.commitNotFound(commitId.toString());
            future2.set((Object)false);
        }
    }

    private void showMessage(@NotNull MessageType messageType, @NotNull String message) {
        if (messageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageType", "com/intellij/vcs/log/ui/VcsLogUiImpl", "showMessage"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/vcs/log/ui/VcsLogUiImpl", "showMessage"));
        }
        LOG.info(message);
        VcsBalloonProblemNotifier.showOverChangesView(this.myProject, message, messageType, new NamedRunnable[0]);
    }

    private void commitNotFound(@NotNull String commitHash) {
        if (commitHash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitHash", "com/intellij/vcs/log/ui/VcsLogUiImpl", "commitNotFound"));
        }
        if (this.myMainFrame.getFilterUi().getFilters().isEmpty()) {
            this.showMessage(MessageType.WARNING, "Commit " + commitHash + " not found");
        } else {
            this.showMessage(MessageType.WARNING, "Commit " + commitHash + " doesn't exist or doesn't match the active filters");
        }
    }

    public boolean isMultipleRoots() {
        return this.myColorManager.isMultipleRoots();
    }

    @NotNull
    public VcsLogColorManager getColorManager() {
        VcsLogColorManager vcsLogColorManager = this.myColorManager;
        if (vcsLogColorManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getColorManager"));
        }
        return vcsLogColorManager;
    }

    public void applyFiltersAndUpdateUi() {
        VcsLogFilterCollection filters = this.myMainFrame.getFilterUi().getFilters();
        this.myFilterer.onFiltersChange(filters);
        this.myMainFrame.onFiltersChange(filters);
    }

    @NotNull
    public VcsLogFilterer getFilterer() {
        VcsLogFilterer vcsLogFilterer = this.myFilterer;
        if (vcsLogFilterer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getFilterer"));
        }
        return vcsLogFilterer;
    }

    public VcsLogGraphTable getTable() {
        return this.myMainFrame.getGraphTable();
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getProject"));
        }
        return project2;
    }

    public void setBranchesPanelVisible(boolean visible) {
        this.myMainFrame.setBranchesPanelVisible(visible);
        this.myUiProperties.setShowBranchesPanel(visible);
    }

    public boolean isBranchesPanelVisible() {
        return this.myUiProperties.isShowBranchesPanel();
    }

    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myMainFrame.getToolbar();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getToolbar"));
        }
        return jComponent;
    }

    @NotNull
    public VcsLog getVcsLog() {
        VcsLog vcsLog = this.myLog;
        if (vcsLog == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getVcsLog"));
        }
        return vcsLog;
    }

    @NotNull
    public VcsLogFilterUi getFilterUi() {
        VcsLogFilterUi vcsLogFilterUi = this.myMainFrame.getFilterUi();
        if (vcsLogFilterUi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getFilterUi"));
        }
        return vcsLogFilterUi;
    }

    @NotNull
    public VisiblePack getDataPack() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        VisiblePack visiblePack = this.myVisiblePack;
        if (visiblePack == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/VcsLogUiImpl", "getDataPack"));
        }
        return visiblePack;
    }

    public void addLogListener(@NotNull VcsLogListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/ui/VcsLogUiImpl", "addLogListener"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.add(listener2);
    }

    public void removeLogListener(@NotNull VcsLogListener listener2) {
        if (listener2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/vcs/log/ui/VcsLogUiImpl", "removeLogListener"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myLogListeners.remove(listener2);
    }

    private void fireFilterChangeEvent(@NotNull VisiblePack visiblePack, boolean refresh) {
        if (visiblePack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visiblePack", "com/intellij/vcs/log/ui/VcsLogUiImpl", "fireFilterChangeEvent"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ArrayList<VcsLogListener> logListeners = new ArrayList<VcsLogListener>(this.myLogListeners);
        for (VcsLogListener listener2 : logListeners) {
            listener2.onChange((VcsLogDataPack)visiblePack, refresh);
        }
    }

    public void invokeOnChange(final @NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/vcs/log/ui/VcsLogUiImpl", "invokeOnChange"));
        }
        this.addLogListener(new VcsLogListener(){

            public void onChange(@NotNull VcsLogDataPack dataPack, boolean refreshHappened) {
                if (dataPack == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataPack", "com/intellij/vcs/log/ui/VcsLogUiImpl$1", "onChange"));
                }
                runnable2.run();
                VcsLogUiImpl.this.removeLogListener(this);
            }
        });
    }

    public void dispose() {
        this.myFilterer.removeVisiblePackChangeListener(this.myVisiblePackChangeListener);
        this.getTable().removeAllHighlighters();
        this.myVisiblePack = VisiblePack.EMPTY;
    }
}

