/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.vcs.log.impl.VcsLogContentProvider;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogDataKeys;

public class OpenAnotherLogTabAction
extends DumbAwareAction {
    protected OpenAnotherLogTabAction() {
        super("Open Another Log Tab", "Open Another Log Tab", AllIcons.General.Add);
    }

    public void update(AnActionEvent e) {
        Project project2 = e.getProject();
        if (project2 == null || !Registry.is((String)"vcs.log.open.another.log.visible")) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        VcsProjectLog projectLog = VcsProjectLog.getInstance(project2);
        VcsLogManager logManager = (VcsLogManager)e.getData(VcsLogDataKeys.LOG_MANAGER);
        e.getPresentation().setEnabledAndVisible(logManager != null && projectLog.getLogManager() == logManager);
    }

    public void actionPerformed(AnActionEvent e) {
        VcsLogContentProvider.openAnotherLogTab((VcsLogManager)e.getRequiredData(VcsLogDataKeys.LOG_MANAGER), (Project)e.getRequiredData(CommonDataKeys.PROJECT));
    }
}

