/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.RoundRectangle2D;
import org.jetbrains.annotations.NotNull;

public class TextLabelPainter {
    protected static final int TEXT_PADDING_X = 5;
    protected static final int TOP_TEXT_PADDING = 2;
    protected static final int BOTTOM_TEXT_PADDING = 1;
    private static final int LABEL_ARC = 5;
    private final boolean mySquare;

    public TextLabelPainter(boolean square) {
        this.mySquare = square;
    }

    public static TextLabelPainter createPainter(boolean paintFlag) {
        boolean square = Registry.is((String)"vcs.log.square.labels");
        if (paintFlag) {
            return square ? new UnderlinedLabelPainter() : new FlagLabelPainter();
        }
        return new TextLabelPainter(square);
    }

    public static Font getFont() {
        return UIUtil.getLabelFont();
    }

    protected Rectangle paint(@NotNull Graphics2D g2, @NotNull String text, int paddingX, int paddingY, int textPadding, @NotNull Color color) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/TextLabelPainter", "paint"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/render/TextLabelPainter", "paint"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/ui/render/TextLabelPainter", "paint"));
        }
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.setFont(TextLabelPainter.getFont());
        g2.setStroke(new BasicStroke(1.5f));
        FontMetrics fontMetrics = g2.getFontMetrics();
        int width = fontMetrics.stringWidth(text) + 10 + textPadding;
        int height = fontMetrics.getHeight() + 2 + 1;
        g2.setColor(color);
        if (this.mySquare) {
            g2.fillRect(paddingX, paddingY, width, height);
        } else {
            g2.fill(new RoundRectangle2D.Double(paddingX, paddingY, width, height, 5.0, 5.0));
        }
        g2.setColor((Color)JBColor.BLACK);
        int x = paddingX + textPadding + 5;
        int y = paddingY + SimpleColoredComponent.getTextBaseLine((FontMetrics)fontMetrics, (int)height);
        g2.drawString(text, x, y);
        config.restore();
        return new Rectangle(x, y, width, height);
    }

    public Rectangle paint(@NotNull Graphics2D g2, @NotNull String text, int paddingX, int paddingY, @NotNull Color color) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/TextLabelPainter", "paint"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/render/TextLabelPainter", "paint"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/vcs/log/ui/render/TextLabelPainter", "paint"));
        }
        return this.paint(g2, text, paddingX, paddingY, 0, color);
    }

    public Rectangle paint(@NotNull Graphics2D g2, @NotNull String text, int paddingX, int paddingY, @NotNull Color labelColor, @NotNull Color flagColor) {
        if (g2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/TextLabelPainter", "paint"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/render/TextLabelPainter", "paint"));
        }
        if (labelColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelColor", "com/intellij/vcs/log/ui/render/TextLabelPainter", "paint"));
        }
        if (flagColor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flagColor", "com/intellij/vcs/log/ui/render/TextLabelPainter", "paint"));
        }
        return this.paint(g2, text, paddingX, paddingY, 0, labelColor);
    }

    public Dimension calculateSize(@NotNull String text, @NotNull FontMetrics metrics) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/render/TextLabelPainter", "calculateSize"));
        }
        if (metrics == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metrics", "com/intellij/vcs/log/ui/render/TextLabelPainter", "calculateSize"));
        }
        int width = metrics.stringWidth(text) + 10;
        int height = metrics.getHeight() + 2 + 1;
        return new Dimension(width, height);
    }

    private static class UnderlinedLabelPainter
    extends TextLabelPainter {
        private static final int LINE_GAP = 1;
        private static final int LINE_HEIGHT = 4;

        public UnderlinedLabelPainter() {
            super(true);
        }

        @Override
        public Rectangle paint(@NotNull Graphics2D g2, @NotNull String text, int paddingX, int paddingY, @NotNull Color labelColor, @NotNull Color flagColor) {
            if (g2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/TextLabelPainter$UnderlinedLabelPainter", "paint"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/render/TextLabelPainter$UnderlinedLabelPainter", "paint"));
            }
            if (labelColor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelColor", "com/intellij/vcs/log/ui/render/TextLabelPainter$UnderlinedLabelPainter", "paint"));
            }
            if (flagColor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flagColor", "com/intellij/vcs/log/ui/render/TextLabelPainter$UnderlinedLabelPainter", "paint"));
            }
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
            Rectangle rectangle = super.paint(g2, text, paddingX, paddingY, 0, labelColor);
            g2.setColor(flagColor);
            g2.fillRect(paddingX, paddingY + rectangle.height + 1, rectangle.width, 4);
            config.restore();
            return new Rectangle(paddingX, paddingY, rectangle.width, rectangle.height + 1 + 4);
        }

        @Override
        public Dimension calculateSize(@NotNull String text, @NotNull FontMetrics metrics) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/render/TextLabelPainter$UnderlinedLabelPainter", "calculateSize"));
            }
            if (metrics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metrics", "com/intellij/vcs/log/ui/render/TextLabelPainter$UnderlinedLabelPainter", "calculateSize"));
            }
            Dimension size = super.calculateSize(text, metrics);
            return new Dimension(size.width, size.height + 1 + 4);
        }
    }

    private static class FlagLabelPainter
    extends TextLabelPainter {
        private static final int FLAG_WIDTH = 8;
        private static final int FLAG_PADDING = 6;
        private static final int FLAG_TOP_INDENT = 2;

        public FlagLabelPainter() {
            super(false);
        }

        @Override
        public Rectangle paint(@NotNull Graphics2D g2, @NotNull String text, int paddingX, int paddingY, @NotNull Color labelColor, @NotNull Color flagColor) {
            if (g2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g2", "com/intellij/vcs/log/ui/render/TextLabelPainter$FlagLabelPainter", "paint"));
            }
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/render/TextLabelPainter$FlagLabelPainter", "paint"));
            }
            if (labelColor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labelColor", "com/intellij/vcs/log/ui/render/TextLabelPainter$FlagLabelPainter", "paint"));
            }
            if (flagColor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flagColor", "com/intellij/vcs/log/ui/render/TextLabelPainter$FlagLabelPainter", "paint"));
            }
            GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g2);
            Rectangle rectangle = super.paint(g2, text, paddingX, paddingY + 2, 15, labelColor);
            g2.setColor(flagColor);
            int x0 = paddingX + 6;
            int xMid = x0 + 4;
            int xRight = x0 + 8;
            int y0 = paddingY;
            int yMid = y0 + 2 * rectangle.height / 3 - 2;
            int yBottom = y0 + rectangle.height - 4;
            Polygon polygon = new Polygon(new int[]{x0, xRight, xRight, xMid, x0}, new int[]{y0, y0, yMid, yBottom, yMid}, 5);
            g2.fillPolygon(polygon);
            config.restore();
            return new Rectangle(paddingX, paddingY, rectangle.width, rectangle.height + 2);
        }

        @Override
        public Dimension calculateSize(@NotNull String text, @NotNull FontMetrics metrics) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/vcs/log/ui/render/TextLabelPainter$FlagLabelPainter", "calculateSize"));
            }
            if (metrics == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "metrics", "com/intellij/vcs/log/ui/render/TextLabelPainter$FlagLabelPainter", "calculateSize"));
            }
            Dimension size = super.calculateSize(text, metrics);
            return new Dimension(size.width + 8 + 12 - 5, size.height + 2);
        }
    }
}

