/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints.ui;

import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.Icon;
import javax.swing.JPanel;

public abstract class AbstractBreakpointPanel<B> {
    private final String myTabName;
    private final String myHelpID;
    private final Class<B> myBreakpointClass;
    private final EventDispatcher<ChangesListener> myEventDispatcher = EventDispatcher.create(ChangesListener.class);

    protected AbstractBreakpointPanel(String tabName, String helpID, Class<B> breakpointClass) {
        this.myTabName = tabName;
        this.myHelpID = helpID;
        this.myBreakpointClass = breakpointClass;
    }

    public String getTabTitle() {
        return this.myTabName;
    }

    public String getHelpID() {
        return this.myHelpID;
    }

    public abstract void dispose();

    public abstract Icon getTabIcon();

    public abstract void resetBreakpoints();

    public abstract void saveBreakpoints();

    public abstract JPanel getPanel();

    public abstract boolean canSelectBreakpoint(B var1);

    public abstract void selectBreakpoint(B var1);

    public abstract boolean hasBreakpoints();

    public void addChangesListener(ChangesListener listener2) {
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public void removeChangesListener(ChangesListener listener2) {
        this.myEventDispatcher.removeListener((EventListener)listener2);
    }

    public Class<B> getBreakpointClass() {
        return this.myBreakpointClass;
    }

    public void ensureSelectionExists() {
    }

    protected void fireBreakpointsChanged() {
        ((ChangesListener)this.myEventDispatcher.getMulticaster()).breakpointsChanged();
    }

    public static interface ChangesListener
    extends EventListener {
        public void breakpointsChanged();
    }
}

