/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.IntIntHashMap;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallback;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class XFetchValueActionBase
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase", "update"));
        }
        for (XValueNodeImpl node : XDebuggerTreeActionBase.getSelectedNodes(e.getDataContext())) {
            if (!this.isEnabled(e, node)) continue;
            return;
        }
        e.getPresentation().setEnabled(false);
    }

    protected boolean isEnabled(@NotNull AnActionEvent event, @NotNull XValueNodeImpl node) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase", "isEnabled"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase", "isEnabled"));
        }
        if (node instanceof WatchNodeImpl || node.isComputed()) {
            event.getPresentation().setEnabled(true);
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase", "actionPerformed"));
        }
        List<XValueNodeImpl> nodes = XDebuggerTreeActionBase.getSelectedNodes(e.getDataContext());
        if (nodes.isEmpty()) {
            return;
        }
        ValueCollector valueCollector = this.createCollector(e);
        for (XValueNodeImpl node : nodes) {
            this.addToCollector(nodes, node, valueCollector);
        }
        valueCollector.processed = true;
        valueCollector.finish();
    }

    protected void addToCollector(@NotNull List<XValueNodeImpl> paths, @NotNull XValueNodeImpl valueNode, @NotNull ValueCollector valueCollector) {
        if (paths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "paths", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase", "addToCollector"));
        }
        if (valueNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueNode", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase", "addToCollector"));
        }
        if (valueCollector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueCollector", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase", "addToCollector"));
        }
        if (paths.size() > 1) {
            valueCollector.add(valueNode.getText().toString(), valueNode.getPath().getPathCount());
        } else {
            XFullValueEvaluator fullValueEvaluator = valueNode.getFullValueEvaluator();
            if (fullValueEvaluator == null || !fullValueEvaluator.isShowValuePopup()) {
                valueCollector.add(StringUtil.notNullize((String)DebuggerUIUtil.getNodeRawValue(valueNode)));
            } else {
                new CopyValueEvaluationCallback(valueNode, valueCollector).startFetchingValue(fullValueEvaluator);
            }
        }
    }

    @NotNull
    protected ValueCollector createCollector(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase", "createCollector"));
        }
        ValueCollector valueCollector = new ValueCollector(XDebuggerTree.getTree(e.getDataContext()));
        if (valueCollector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase", "createCollector"));
        }
        return valueCollector;
    }

    protected abstract void handle(Project var1, String var2, XDebuggerTree var3);

    private static final class CopyValueEvaluationCallback
    extends HeadlessValueEvaluationCallback {
        private final int myValueIndex;
        private final ValueCollector myValueCollector;

        public CopyValueEvaluationCallback(@NotNull XValueNodeImpl node, @NotNull ValueCollector valueCollector) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback", "<init>"));
            }
            if (valueCollector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueCollector", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback", "<init>"));
            }
            super(node);
            this.myValueCollector = valueCollector;
            this.myValueIndex = valueCollector.acquire();
        }

        @Override
        protected void evaluationComplete(@NotNull String value, @NotNull Project project2) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback", "evaluationComplete"));
            }
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback", "evaluationComplete"));
            }
            this.myValueCollector.evaluationComplete(this.myValueIndex, value);
        }
    }

    public class ValueCollector {
        private final List<String> values = new SmartList();
        private final IntIntHashMap indents = new IntIntHashMap();
        private final XDebuggerTree myTree;
        private volatile boolean processed;

        public ValueCollector(XDebuggerTree tree) {
            this.myTree = tree;
        }

        public void add(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$ValueCollector", "add"));
            }
            this.values.add(value);
        }

        public void add(@NotNull String value, int indent) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$ValueCollector", "add"));
            }
            this.values.add(value);
            this.indents.put(this.values.size() - 1, indent);
        }

        public void finish() {
            Project project2 = this.myTree.getProject();
            if (this.processed && !this.values.contains(null) && !project2.isDisposed()) {
                int minIndent = Integer.MAX_VALUE;
                for (int indent : this.indents.getValues()) {
                    minIndent = Math.min(minIndent, indent);
                }
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < this.values.size(); ++i) {
                    int indent;
                    if (i > 0) {
                        sb.append("\n");
                    }
                    if ((indent = this.indents.get(i)) > 0) {
                        StringUtil.repeatSymbol((Appendable)sb, (char)' ', (int)(indent - minIndent));
                    }
                    sb.append(this.values.get(i));
                }
                this.handleInCollector(project2, sb.toString(), this.myTree);
            }
        }

        public void handleInCollector(Project project2, String value, XDebuggerTree tree) {
            XFetchValueActionBase.this.handle(project2, value, tree);
        }

        public int acquire() {
            int index = this.values.size();
            this.values.add(null);
            return index;
        }

        public void evaluationComplete(int index, @NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$ValueCollector", "evaluationComplete"));
            }
            AppUIUtil.invokeOnEdt(() -> {
                if (value == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$ValueCollector", "lambda$evaluationComplete$0"));
                }
                this.values.set(index, value);
                this.finish();
            });
        }
    }
}

