/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.awt.Font;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HeadlessValueEvaluationCallback
implements XFullValueEvaluator.XFullValueEvaluationCallback {
    private final XValueNodeImpl myNode;
    private volatile boolean myEvaluated;
    private volatile boolean myCanceled;
    private final Semaphore mySemaphore;

    public HeadlessValueEvaluationCallback(@NotNull XValueNodeImpl node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/nodes/HeadlessValueEvaluationCallback", "<init>"));
        }
        this.myNode = node;
        this.mySemaphore = new Semaphore();
        this.mySemaphore.down();
    }

    public void startFetchingValue(@NotNull XFullValueEvaluator fullValueEvaluator) {
        if (fullValueEvaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullValueEvaluator", "com/intellij/xdebugger/impl/ui/tree/nodes/HeadlessValueEvaluationCallback", "startFetchingValue"));
        }
        fullValueEvaluator.startEvaluation((XFullValueEvaluator.XFullValueEvaluationCallback)this);
        new Alarm().addRequest(() -> this.showProgress(), 500);
    }

    public void evaluated(@NotNull String fullValue) {
        if (fullValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullValue", "com/intellij/xdebugger/impl/ui/tree/nodes/HeadlessValueEvaluationCallback", "evaluated"));
        }
        this.evaluationComplete(fullValue);
    }

    public void evaluated(@NotNull String fullValue, @Nullable Font font) {
        if (fullValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fullValue", "com/intellij/xdebugger/impl/ui/tree/nodes/HeadlessValueEvaluationCallback", "evaluated"));
        }
        this.evaluated(fullValue);
    }

    public void errorOccurred(@NotNull String errorMessage) {
        if (errorMessage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/ui/tree/nodes/HeadlessValueEvaluationCallback", "errorOccurred"));
        }
        try {
            String message = XDebuggerBundle.message((String)"load.value.task.error", (Object[])new Object[]{errorMessage});
            XDebugSessionImpl.NOTIFICATION_GROUP.createNotification(message, NotificationType.ERROR).notify(this.myNode.getTree().getProject());
        }
        finally {
            this.evaluationComplete(errorMessage);
        }
    }

    private void evaluationComplete(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/HeadlessValueEvaluationCallback", "evaluationComplete"));
        }
        try {
            this.myEvaluated = true;
            this.mySemaphore.up();
        }
        finally {
            this.evaluationComplete(value, this.myNode.getTree().getProject());
        }
    }

    protected void evaluationComplete(@NotNull String value, @NotNull Project project2) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/HeadlessValueEvaluationCallback", "evaluationComplete"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/ui/tree/nodes/HeadlessValueEvaluationCallback", "evaluationComplete"));
        }
    }

    public boolean isObsolete() {
        return this.myCanceled;
    }

    public void showProgress() {
        if (this.myEvaluated || this.myNode.isObsolete()) {
            return;
        }
        new Task.Backgroundable(this.myNode.getTree().getProject(), XDebuggerBundle.message((String)"load.value.task.text", (Object[])new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/xdebugger/impl/ui/tree/nodes/HeadlessValueEvaluationCallback$1", "run"));
                }
                indicator.setIndeterminate(true);
                int i = 0;
                while (!HeadlessValueEvaluationCallback.this.myCanceled && !HeadlessValueEvaluationCallback.this.myEvaluated) {
                    indicator.checkCanceled();
                    indicator.setFraction((double)(i++ % 100) * 0.01);
                    HeadlessValueEvaluationCallback.this.mySemaphore.waitFor(300L);
                }
            }

            public boolean shouldStartInBackground() {
                return false;
            }

            public void onCancel() {
                HeadlessValueEvaluationCallback.this.myCanceled = true;
            }
        }.queue();
    }
}

