/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension.schema;

import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.jsonSchema.extension.schema.JsonSchemaFileIndex;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResourcesRootsProvider;
import com.jetbrains.jsonSchema.impl.JsonSchemaWalker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaDefinitionResolver {
    @Nullable
    private String myRef;
    @Nullable
    JsonSchemaObject mySchemaObject;
    @NotNull
    private final PsiElement myElement;
    @Nullable
    final String mySchemaId;
    private boolean myInCurrentFile;

    public JsonSchemaDefinitionResolver(@NotNull PsiElement element, @Nullable String schemaId) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaDefinitionResolver", "<init>"));
        }
        this.myElement = element;
        this.mySchemaId = schemaId;
    }

    public JsonSchemaDefinitionResolver setSchemaObject(@NotNull JsonSchemaObject value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaDefinitionResolver", "setSchemaObject"));
        }
        this.mySchemaObject = value;
        return this;
    }

    public JsonSchemaDefinitionResolver setRef(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaDefinitionResolver", "setRef"));
        }
        this.myRef = value;
        return this;
    }

    @Nullable
    public PsiElement doResolve() {
        PsiElement result2 = this.tryResolveByName();
        if (result2 != null) {
            return result2;
        }
        if (this.mySchemaId == null) {
            return this.tryResolveBySchemaObject();
        }
        return null;
    }

    private PsiElement tryResolveBySchemaObject() {
        if (!(this.myElement.getParent() instanceof JsonProperty)) {
            return null;
        }
        final Ref ref = new Ref();
        final String propertyName = ((JsonProperty)this.myElement.getParent()).getName();
        JsonSchemaService.Impl.getEx(this.myElement.getProject()).iterateSchemaObjects(this.myElement.getContainingFile().getVirtualFile(), (Processor<JsonSchemaObject>)((Processor)object -> {
            JsonSchemaWalker.CompletionSchemesConsumer consumer = new JsonSchemaWalker.CompletionSchemesConsumer(){

                @Override
                public void consume(boolean isName, @NotNull JsonSchemaObject schema) {
                    if (schema == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/jetbrains/jsonSchema/extension/schema/JsonSchemaDefinitionResolver$1", "consume"));
                    }
                    if (!ref.isNull()) {
                        return;
                    }
                    String definitionAddress = schema.getDefinitionAddress();
                    if (!StringUtil.isEmptyOrSpaces((String)definitionAddress) && definitionAddress.startsWith("#")) {
                        definitionAddress = definitionAddress.substring(1) + "/properties/" + propertyName;
                        ref.set((Object)JsonSchemaDefinitionResolver.this.resolveByPath(definitionAddress));
                        if (!ref.isNull()) {
                            return;
                        }
                    }
                    ArrayList<JsonSchemaObject> list = new ArrayList<JsonSchemaObject>();
                    if (schema.getAllOf() != null) {
                        list.addAll(schema.getAllOf());
                    }
                    if (schema.getAnyOf() != null) {
                        list.addAll(schema.getAnyOf());
                    }
                    if (schema.getOneOf() != null) {
                        list.addAll(schema.getOneOf());
                    }
                    for (JsonSchemaObject schemaObject : list) {
                        definitionAddress = schemaObject.getDefinitionAddress();
                        if (StringUtil.isEmptyOrSpaces((String)definitionAddress) || !definitionAddress.startsWith("#")) continue;
                        definitionAddress = definitionAddress.substring(1) + "/properties/" + propertyName;
                        ref.set((Object)JsonSchemaDefinitionResolver.this.resolveByPath(definitionAddress));
                        if (ref.isNull()) continue;
                        return;
                    }
                }
            };
            List<JsonSchemaWalker.Step> position = JsonSchemaWalker.findPosition(((JsonProperty)this.myElement.getParent()).getNameElement(), true);
            if (position == null || position.isEmpty()) {
                return true;
            }
            JsonSchemaWalker.extractSchemaVariants(consumer, object, true, position);
            return ref.isNull();
        }));
        return (PsiElement)ref.get();
    }

    private PsiElement tryResolveByName() {
        if (this.myRef == null) {
            this.initializeName();
        }
        if (this.myRef == null) {
            return null;
        }
        return this.resolveByPath(this.myRef);
    }

    @Nullable
    private PsiElement resolveByPath(String referenceName) {
        final Project project2 = this.myElement.getProject();
        FileBasedIndex index = FileBasedIndex.getInstance();
        final Ref reference = new Ref();
        GlobalSearchScope filter = this.mySchemaId != null && this.myInCurrentFile ? GlobalSearchScope.fileScope((PsiFile)this.myElement.getContainingFile()) : GlobalSearchScope.allScope((Project)project2);
        filter = JsonSchemaResourcesRootsProvider.enlarge(project2, filter);
        index.processValues(JsonSchemaFileIndex.PROPERTIES_INDEX, (Object)referenceName, null, (FileBasedIndex.ValueProcessor)new FileBasedIndex.ValueProcessor<Integer>(){

            public boolean process(VirtualFile file2, Integer value) {
                if (JsonSchemaDefinitionResolver.this.mySchemaId != null && !JsonSchemaService.Impl.getEx(project2).checkFileForId(JsonSchemaDefinitionResolver.this.mySchemaId, file2)) {
                    return true;
                }
                reference.set((Object)Pair.create((Object)file2, (Object)value));
                return false;
            }
        }, filter);
        if (!reference.isNull()) {
            Pair pair = (Pair)reference.get();
            PsiFile file2 = this.myElement.getManager().findFile((VirtualFile)pair.getFirst());
            if (file2 != null) {
                return file2.findElementAt(((Integer)pair.getSecond()).intValue());
            }
        }
        return null;
    }

    private void initializeName() {
        ArrayList<String> names = new ArrayList<String>();
        PsiElement parent = this.myElement.getParent();
        if (!(parent instanceof JsonProperty)) {
            return;
        }
        JsonProperty element = (JsonProperty)parent;
        while (true) {
            PsiElement grand;
            names.add(StringUtil.unquoteString((String)element.getName()));
            if (!(element.getParent() instanceof JsonObject) || !((grand = element.getParent().getParent()) instanceof JsonProperty) || ((JsonProperty)grand).getValue() == null || !((JsonProperty)grand).getValue().equals(element.getParent())) break;
            element = (JsonProperty)grand;
        }
        StringBuilder path = new StringBuilder();
        Collections.reverse(names);
        for (String name : names) {
            path.append("/properties/").append(name);
        }
        this.myRef = path.toString();
    }

    public JsonSchemaDefinitionResolver setInCurrentFile(boolean inCurrentFile) {
        this.myInCurrentFile = inCurrentFile;
        return this;
    }
}

