/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.UIUtil;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.GroupDisplayNameUtil;
import com.siyeh.ig.InspectionGadgetsFix;
import java.lang.reflect.Field;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import javax.swing.JFormattedTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)"#com.siyeh.ig.BaseInspection");
    private String m_shortName = null;

    @NotNull
    public String getShortName() {
        if (this.m_shortName == null) {
            Class<?> aClass = ((Object)((Object)this)).getClass();
            String name = aClass.getSimpleName();
            this.m_shortName = InspectionProfileEntry.getShortName((String)name);
            if (this.m_shortName.equals(name)) {
                throw new AssertionError((Object)("class name must end with 'Inspection' to correctly calculate the short name: " + name));
            }
        }
        String string = this.m_shortName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/BaseInspection", "getShortName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public abstract String getDisplayName();

    @Nls
    @NotNull
    public final String getGroupDisplayName() {
        String string = GroupDisplayNameUtil.getGroupDisplayName(((Object)((Object)this)).getClass());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/BaseInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    protected abstract String buildErrorString(Object ... var1);

    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return false;
    }

    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return null;
    }

    @NotNull
    protected InspectionGadgetsFix[] buildFixes(Object ... infos) {
        if (InspectionGadgetsFix.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/BaseInspection", "buildFixes"));
        }
        return InspectionGadgetsFix.EMPTY_ARRAY;
    }

    protected void writeBooleanOption(@NotNull Element node, @NotNull @NonNls String property, boolean defaultValueToIgnore) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/BaseInspection", "writeBooleanOption"));
        }
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/siyeh/ig/BaseInspection", "writeBooleanOption"));
        }
        Boolean value = (Boolean)ReflectionUtil.getField(((Object)((Object)this)).getClass(), (Object)((Object)this), Boolean.TYPE, (String)property);
        assert (value != null);
        if (defaultValueToIgnore == value) {
            return;
        }
        node.addContent(new Element("option").setAttribute("name", property).setAttribute("value", value.toString()));
    }

    protected void defaultWriteSettings(@NotNull Element node, final String ... excludedProperties) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/siyeh/ig/BaseInspection", "defaultWriteSettings"));
        }
        DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)node, (DefaultJDOMExternalizer.JDOMFilter)new DefaultJDOMExternalizer.JDOMFilter(){

            public boolean isAccept(@NotNull Field field) {
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "com/siyeh/ig/BaseInspection$1", "isAccept"));
                }
                String name = field.getName();
                for (String property : excludedProperties) {
                    if (!name.equals(property)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public abstract BaseInspectionVisitor buildVisitor();

    @NotNull
    public final PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/siyeh/ig/BaseInspection", "buildVisitor"));
        }
        if (!this.shouldInspect(holder.getFile())) {
            PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){};
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/BaseInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        BaseInspectionVisitor visitor = this.buildVisitor();
        visitor.setProblemsHolder(holder);
        visitor.setOnTheFly(isOnTheFly);
        visitor.setInspection(this);
        BaseInspectionVisitor baseInspectionVisitor = visitor;
        if (baseInspectionVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/BaseInspection", "buildVisitor"));
        }
        return baseInspectionVisitor;
    }

    public boolean shouldInspect(PsiFile file2) {
        return true;
    }

    protected JFormattedTextField prepareNumberEditor(final @NonNls String fieldName) {
        NumberFormat formatter = NumberFormat.getIntegerInstance();
        formatter.setParseIntegerOnly(true);
        final JFormattedTextField valueField = new JFormattedTextField(formatter);
        Object value = ReflectionUtil.getField(((Object)((Object)this)).getClass(), (Object)((Object)this), null, (String)fieldName);
        valueField.setValue(value);
        valueField.setColumns(2);
        valueField.setMinimumSize(valueField.getPreferredSize());
        UIUtil.fixFormattedField((JFormattedTextField)valueField);
        Document document2 = valueField.getDocument();
        document2.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void textChanged(DocumentEvent evt) {
                try {
                    valueField.commitEdit();
                    Number number = (Number)valueField.getValue();
                    ReflectionUtil.setField(((Object)((Object)BaseInspection.this)).getClass(), (Object)((Object)BaseInspection.this), Integer.TYPE, (String)fieldName, (Object)number.intValue());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        });
        return valueField;
    }

    public static void parseString(String string, List<String> ... outs) {
        List strings = StringUtil.split((String)string, (String)",");
        for (List<String> out : outs) {
            out.clear();
        }
        int iMax = strings.size();
        for (int i = 0; i < iMax; i += outs.length) {
            for (int j = 0; j < outs.length; ++j) {
                List<String> out;
                out = outs[j];
                if (i + j >= iMax) {
                    out.add("");
                    continue;
                }
                out.add((String)strings.get(i + j));
            }
        }
    }

    public static String formatString(List<String> ... strings) {
        StringBuilder buffer = new StringBuilder();
        int size = strings[0].size();
        if (size > 0) {
            BaseInspection.formatString(strings, 0, buffer);
            for (int i = 1; i < size; ++i) {
                buffer.append(',');
                BaseInspection.formatString(strings, i, buffer);
            }
        }
        return buffer.toString();
    }

    private static void formatString(List<String>[] strings, int index, StringBuilder out) {
        out.append(strings[0].get(index));
        for (int i = 1; i < strings.length; ++i) {
            out.append(',');
            out.append(strings[i].get(index));
        }
    }

    public static boolean isInspectionEnabled(@NonNls String shortName, PsiElement context) {
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(context.getProject());
        InspectionProfileImpl profile = (InspectionProfileImpl)profileManager.getInspectionProfile();
        HighlightDisplayKey key2 = HighlightDisplayKey.find((String)shortName);
        return profile.isToolEnabled(key2, context);
    }
}

