/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnumSwitchStatementWhichMissesCasesInspection
extends BaseInspection {
    public boolean ignoreSwitchStatementsWithDefault = false;

    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/EnumSwitchStatementWhichMissesCasesInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)infos[0];
        assert (switchStatement != null);
        PsiExpression switchStatementExpression = switchStatement.getExpression();
        assert (switchStatementExpression != null);
        PsiType switchStatementType = switchStatementExpression.getType();
        assert (switchStatementType != null);
        String switchStatementTypeText = switchStatementType.getPresentableText();
        String string = InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.problem.descriptor", switchStatementTypeText);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/controlflow/EnumSwitchStatementWhichMissesCasesInspection", "buildErrorString"));
        }
        return string;
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("enum.switch.statement.which.misses.cases.option", new Object[0]), (InspectionProfileEntry)this, "ignoreSwitchStatementsWithDefault");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new EnumSwitchStatementWhichMissesCasesVisitor();
    }

    private class EnumSwitchStatementWhichMissesCasesVisitor
    extends BaseInspectionVisitor {
        private EnumSwitchStatementWhichMissesCasesVisitor() {
        }

        public void visitSwitchStatement(@NotNull PsiSwitchStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/controlflow/EnumSwitchStatementWhichMissesCasesInspection$EnumSwitchStatementWhichMissesCasesVisitor", "visitSwitchStatement"));
            }
            super.visitSwitchStatement(statement2);
            if (!this.switchStatementMissingCases(statement2)) {
                return;
            }
            this.registerStatementError((PsiStatement)statement2, statement2);
        }

        private boolean switchStatementMissingCases(PsiSwitchStatement statement2) {
            PsiExpression expression = statement2.getExpression();
            if (expression == null) {
                return false;
            }
            PsiType type = expression.getType();
            if (!(type instanceof PsiClassType)) {
                return false;
            }
            PsiClassType classType = (PsiClassType)type;
            PsiClass aClass = classType.resolve();
            if (aClass == null || !aClass.isEnum()) {
                return false;
            }
            PsiCodeBlock body = statement2.getBody();
            if (body == null) {
                return false;
            }
            PsiStatement[] statements = body.getStatements();
            int numCases = 0;
            for (PsiStatement child : statements) {
                if (!(child instanceof PsiSwitchLabelStatement)) continue;
                PsiSwitchLabelStatement switchLabelStatement = (PsiSwitchLabelStatement)child;
                if (!switchLabelStatement.isDefaultCase()) {
                    ++numCases;
                    continue;
                }
                if (!EnumSwitchStatementWhichMissesCasesInspection.this.ignoreSwitchStatementsWithDefault) continue;
                return false;
            }
            PsiField[] fields = aClass.getFields();
            int numEnums = 0;
            for (PsiField field : fields) {
                if (!(field instanceof PsiEnumConstant)) continue;
                ++numEnums;
            }
            return numEnums != numCases;
        }
    }
}

