/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.inheritance;

import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.ConvertToVarargsMethodFix;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblematicVarargsMethodOverrideInspection
extends BaseInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("problematic.varargs.method.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ProblematicVarargsMethodOverrideInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("problematic.varargs.method.override.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/inheritance/ProblematicVarargsMethodOverrideInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ConvertToVarargsMethodFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonVarargsMethodOverridesVarArgsMethodVisitor();
    }

    private static class NonVarargsMethodOverridesVarArgsMethodVisitor
    extends BaseInspectionVisitor {
        private NonVarargsMethodOverridesVarArgsMethodVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            PsiMethod[] superMethods;
            super.visitMethod(method);
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters = parameterList.getParameters();
            if (parameters.length == 0) {
                return;
            }
            PsiParameter parameter = parameters[parameters.length - 1];
            PsiType type = parameter.getType();
            if (!(type instanceof PsiArrayType) || type instanceof PsiEllipsisType) {
                return;
            }
            for (PsiMethod superMethod : superMethods = method.findDeepestSuperMethods()) {
                if (!superMethod.isVarArgs()) continue;
                this.registerMethodError(method, new Object[0]);
                return;
            }
        }
    }
}

