/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhileStatement;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class ArrayLengthInLoopConditionInspection
extends BaseInspection {
    @Override
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("array.length.in.loop.condition.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/ArrayLengthInLoopConditionInspection", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        String string = InspectionGadgetsBundle.message("array.length.in.loop.condition.problem.descriptor", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/j2me/ArrayLengthInLoopConditionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ArrayLengthInLoopConditionVisitor();
    }

    private static class ArrayLengthInLoopConditionVisitor
    extends BaseInspectionVisitor {
        private ArrayLengthInLoopConditionVisitor() {
        }

        public void visitForStatement(@NotNull PsiForStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/j2me/ArrayLengthInLoopConditionInspection$ArrayLengthInLoopConditionVisitor", "visitForStatement"));
            }
            super.visitForStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            if (condition == null) {
                return;
            }
            this.checkForMethodCalls(condition);
        }

        public void visitWhileStatement(@NotNull PsiWhileStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/j2me/ArrayLengthInLoopConditionInspection$ArrayLengthInLoopConditionVisitor", "visitWhileStatement"));
            }
            super.visitWhileStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            if (condition == null) {
                return;
            }
            this.checkForMethodCalls(condition);
        }

        public void visitDoWhileStatement(@NotNull PsiDoWhileStatement statement2) {
            if (statement2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/siyeh/ig/j2me/ArrayLengthInLoopConditionInspection$ArrayLengthInLoopConditionVisitor", "visitDoWhileStatement"));
            }
            super.visitDoWhileStatement(statement2);
            PsiExpression condition = statement2.getCondition();
            if (condition == null) {
                return;
            }
            this.checkForMethodCalls(condition);
        }

        private void checkForMethodCalls(PsiExpression condition) {
            JavaRecursiveElementVisitor visitor = new JavaRecursiveElementVisitor(){

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                    if (expression == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/siyeh/ig/j2me/ArrayLengthInLoopConditionInspection$ArrayLengthInLoopConditionVisitor$1", "visitReferenceExpression"));
                    }
                    super.visitReferenceExpression(expression);
                    String name = expression.getReferenceName();
                    if (!"length".equals(name)) {
                        return;
                    }
                    PsiExpression qualifier = expression.getQualifierExpression();
                    if (qualifier == null) {
                        return;
                    }
                    PsiType type = qualifier.getType();
                    if (!(type instanceof PsiArrayType)) {
                        return;
                    }
                    PsiElement lengthElement = expression.getReferenceNameElement();
                    if (lengthElement == null) {
                        return;
                    }
                    this.registerError(lengthElement, new Object[0]);
                }
            };
            condition.accept((PsiElementVisitor)visitor);
        }
    }
}

