/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.packaging;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptionsProcessor;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseGlobalInspection;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmptyDirectoryInspection
extends BaseGlobalInspection {
    public boolean onlyReportDirectoriesUnderSourceRoots = false;

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = InspectionGadgetsBundle.message("empty.directory.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/packaging/EmptyDirectoryInspection", "getDisplayName"));
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("empty.directories.only.under.source.roots.option", new Object[0]), (InspectionProfileEntry)this, "onlyReportDirectoriesUnderSourceRoots");
    }

    public boolean isGraphNeeded() {
        return false;
    }

    public void runInspection(@NotNull AnalysisScope scope, final @NotNull InspectionManager manager, final @NotNull GlobalInspectionContext context, final @NotNull ProblemDescriptionsProcessor processor2) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/siyeh/ig/packaging/EmptyDirectoryInspection", "runInspection"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/siyeh/ig/packaging/EmptyDirectoryInspection", "runInspection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/siyeh/ig/packaging/EmptyDirectoryInspection", "runInspection"));
        }
        if (processor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/siyeh/ig/packaging/EmptyDirectoryInspection", "runInspection"));
        }
        final Project project2 = context.getProject();
        final ProjectFileIndex index = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        SearchScope searchScope = scope.toSearchScope();
        if (!(searchScope instanceof GlobalSearchScope)) {
            return;
        }
        final GlobalSearchScope globalSearchScope = (GlobalSearchScope)searchScope;
        final PsiManager psiManager = PsiManager.getInstance((Project)project2);
        index.iterateContent(new ContentIterator(){

            public boolean processFile(final VirtualFile fileOrDir) {
                if (!fileOrDir.isDirectory()) {
                    return true;
                }
                if (!globalSearchScope.contains(fileOrDir)) {
                    return true;
                }
                if (EmptyDirectoryInspection.this.onlyReportDirectoriesUnderSourceRoots && !index.isInSourceContent(fileOrDir)) {
                    return true;
                }
                VirtualFile[] children2 = fileOrDir.getChildren();
                if (children2.length != 0) {
                    return true;
                }
                Application application = ApplicationManager.getApplication();
                PsiDirectory directory = (PsiDirectory)application.runReadAction((Computable)new Computable<PsiDirectory>(){

                    public PsiDirectory compute() {
                        return psiManager.findDirectory(fileOrDir);
                    }
                });
                RefElement refDirectory = context.getRefManager().getReference((PsiElement)directory);
                if (context.shouldCheck((RefEntity)refDirectory, (GlobalInspectionTool)EmptyDirectoryInspection.this)) {
                    return true;
                }
                String relativePath = EmptyDirectoryInspection.getPathRelativeToModule(fileOrDir, project2);
                if (relativePath == null) {
                    return true;
                }
                processor2.addProblemElement((RefEntity)refDirectory, new CommonProblemDescriptor[]{manager.createProblemDescriptor(InspectionGadgetsBundle.message("empty.directories.problem.descriptor", relativePath), new QuickFix[]{new EmptyPackageFix(fileOrDir.getUrl(), fileOrDir.getName())})});
                return true;
            }
        });
    }

    @Nullable
    private static String getPathRelativeToModule(VirtualFile file2, Project project2) {
        VirtualFile[] contentRoots;
        final ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project2);
        Application application = ApplicationManager.getApplication();
        for (VirtualFile otherRoot : contentRoots = (VirtualFile[])application.runReadAction((Computable)new Computable<VirtualFile[]>(){

            public VirtualFile[] compute() {
                return rootManager.getContentRootsFromAllModules();
            }
        })) {
            if (!VfsUtilCore.isAncestor((VirtualFile)otherRoot, (VirtualFile)file2, (boolean)false)) continue;
            return VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)otherRoot, (char)'/');
        }
        return null;
    }

    private static class EmptyPackageFix
    implements QuickFix {
        private final String url;
        private final String name;

        public EmptyPackageFix(String url, String name) {
            this.url = url;
            this.name = name;
        }

        @NotNull
        public String getName() {
            String string = InspectionGadgetsBundle.message("empty.directories.delete.quickfix", this.name);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/packaging/EmptyDirectoryInspection$EmptyPackageFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionGadgetsBundle.message("empty.directories.delete.quickfix", "");
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ig/packaging/EmptyDirectoryInspection$EmptyPackageFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull CommonProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/siyeh/ig/packaging/EmptyDirectoryInspection$EmptyPackageFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/siyeh/ig/packaging/EmptyDirectoryInspection$EmptyPackageFix", "applyFix"));
            }
            VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(this.url);
            if (file2 == null) {
                return;
            }
            PsiManager psiManager = PsiManager.getInstance((Project)project2);
            PsiDirectory directory = psiManager.findDirectory(file2);
            if (directory == null) {
                return;
            }
            directory.delete();
        }
    }
}

