/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.bool;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class NegateConditionalIntention
extends Intention {
    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/bool/NegateConditionalIntention", "processIntention"));
        }
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
        String newExpression = conditionalExpression.getCondition().getText() + '?' + BoolUtils.getNegatedExpressionText(conditionalExpression.getThenExpression()) + ':' + BoolUtils.getNegatedExpressionText(conditionalExpression.getElseExpression());
        NegateConditionalIntention.replaceExpressionWithNegatedExpressionString(newExpression, (PsiExpression)conditionalExpression);
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        BooleanConditionalExpressionPredicate booleanConditionalExpressionPredicate = new BooleanConditionalExpressionPredicate();
        if (booleanConditionalExpressionPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/bool/NegateConditionalIntention", "getElementPredicate"));
        }
        return booleanConditionalExpressionPredicate;
    }

    private static class BooleanConditionalExpressionPredicate
    implements PsiElementPredicate {
        private BooleanConditionalExpressionPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            if (!(element instanceof PsiConditionalExpression)) {
                return false;
            }
            PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)element;
            PsiType type = conditionalExpression.getType();
            return PsiType.BOOLEAN.equals((Object)type);
        }
    }
}

