/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.opassign;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.psiutils.ErrorUtil;

class ReplaceableWithOperatorAssignmentPredicate
implements PsiElementPredicate {
    ReplaceableWithOperatorAssignmentPredicate() {
    }

    @Override
    public boolean satisfiedBy(PsiElement element) {
        if (!(element instanceof PsiAssignmentExpression)) {
            return false;
        }
        PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
        IElementType tokenType = assignment.getOperationTokenType();
        if (!JavaTokenType.EQ.equals(tokenType)) {
            return false;
        }
        PsiExpression rhs = assignment.getRExpression();
        PsiExpression expression = PsiUtil.deparenthesizeExpression((PsiExpression)rhs);
        if (!(expression instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression polyadicExpression = (PsiPolyadicExpression)expression;
        PsiExpression[] operands = polyadicExpression.getOperands();
        if (operands.length < 2) {
            return false;
        }
        IElementType rhsTokenType = polyadicExpression.getOperationTokenType();
        if (JavaTokenType.OROR.equals(rhsTokenType) || JavaTokenType.ANDAND.equals(rhsTokenType) || JavaTokenType.EQEQ.equals(rhsTokenType) || JavaTokenType.NE.equals(rhsTokenType)) {
            return false;
        }
        PsiExpression lhs = assignment.getLExpression();
        if (SideEffectChecker.mayHaveSideEffects(lhs)) {
            return false;
        }
        if (!EquivalenceChecker.getCanonicalPsiEquivalence().expressionsAreEquivalent(lhs, operands[0])) {
            return false;
        }
        return !ErrorUtil.containsError(element);
    }
}

