/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.trivialif;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import com.siyeh.ipp.trivialif.MergeIfAndPredicate;
import org.jetbrains.annotations.NotNull;

public class MergeIfAndIntention
extends Intention {
    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        MergeIfAndPredicate mergeIfAndPredicate = new MergeIfAndPredicate();
        if (mergeIfAndPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/trivialif/MergeIfAndIntention", "getElementPredicate"));
        }
        return mergeIfAndPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/trivialif/MergeIfAndIntention", "processIntention"));
        }
        PsiJavaToken token = (PsiJavaToken)element;
        PsiIfStatement parentStatement = (PsiIfStatement)token.getParent();
        if (parentStatement == null) {
            return;
        }
        PsiStatement parentThenBranch = parentStatement.getThenBranch();
        PsiIfStatement childStatement = (PsiIfStatement)ControlFlowUtils.stripBraces(parentThenBranch);
        PsiExpression childCondition = childStatement.getCondition();
        if (childCondition == null) {
            return;
        }
        String childConditionText = ParenthesesUtils.getPrecedence(childCondition) > 13 ? '(' + childCondition.getText() + ')' : childCondition.getText();
        PsiExpression parentCondition = parentStatement.getCondition();
        if (parentCondition == null) {
            return;
        }
        String parentConditionText = ParenthesesUtils.getPrecedence(parentCondition) > 13 ? '(' + parentCondition.getText() + ')' : parentCondition.getText();
        PsiStatement childThenBranch = childStatement.getThenBranch();
        if (childThenBranch == null) {
            return;
        }
        String statement2 = "if(" + parentConditionText + "&&" + childConditionText + ')' + childThenBranch.getText();
        PsiReplacementUtil.replaceStatement((PsiStatement)parentStatement, statement2);
    }
}

