/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ipp.types;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.LambdaRefactoringUtil;
import com.siyeh.ipp.base.Intention;
import com.siyeh.ipp.base.PsiElementPredicate;
import org.jetbrains.annotations.NotNull;

public class ReplaceMethodRefWithLambdaIntention
extends Intention {
    private static final Logger LOG = Logger.getInstance((String)("#" + ReplaceMethodRefWithLambdaIntention.class.getName()));

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        MethodRefPredicate methodRefPredicate = new MethodRefPredicate();
        if (methodRefPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/siyeh/ipp/types/ReplaceMethodRefWithLambdaIntention", "getElementPredicate"));
        }
        return methodRefPredicate;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/types/ReplaceMethodRefWithLambdaIntention", "processIntention"));
        }
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    protected void processIntention(Editor editor, @NotNull PsiElement element) {
        PsiLambdaExpression expr;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ipp/types/ReplaceMethodRefWithLambdaIntention", "processIntention"));
        }
        PsiMethodReferenceExpression ref = (PsiMethodReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodReferenceExpression.class);
        PsiLambdaExpression psiLambdaExpression = expr = ref != null ? (PsiLambdaExpression)WriteAction.compute(() -> LambdaRefactoringUtil.convertMethodReferenceToLambda(ref, false, true)) : null;
        if (expr == null) {
            return;
        }
        LambdaRefactoringUtil.removeSideEffectsFromLambdaBody(editor, expr);
    }

    private static class MethodRefPredicate
    implements PsiElementPredicate {
        private MethodRefPredicate() {
        }

        @Override
        public boolean satisfiedBy(PsiElement element) {
            PsiType interfaceType;
            PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodReferenceExpression.class);
            return methodReferenceExpression != null && (interfaceType = methodReferenceExpression.getFunctionalInterfaceType()) != null && LambdaUtil.getFunctionalInterfaceMethod((PsiType)interfaceType) != null && methodReferenceExpression.resolve() != null;
        }
    }
}

