/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.ui.ImageComponent;

public class ImageComponentUI
extends ComponentUI {
    private static final ImageComponentUI ui = new ImageComponentUI();

    @Override
    public void paint(Graphics g, JComponent c) {
        ImageDocument document2;
        BufferedImage image;
        ImageComponent ic = (ImageComponent)c;
        if (ic != null && (image = (document2 = ic.getDocument()).getValue()) != null) {
            this.paintBorder(g, ic);
            Dimension size = ic.getCanvasSize();
            Graphics igc = g.create(2, 2, size.width, size.height);
            if (ic.isTransparencyChessboardVisible()) {
                this.paintChessboard(igc, ic);
            }
            this.paintImage(igc, ic);
            if (ic.isGridVisible()) {
                this.paintGrid(igc, ic);
            }
            igc.dispose();
        }
    }

    private void paintBorder(Graphics g, ImageComponent ic) {
        Dimension size = ic.getSize();
        g.setColor(ic.getTransparencyChessboardBlackColor());
        g.drawRect(0, 0, size.width - 1, size.height - 1);
    }

    private void paintChessboard(Graphics g, ImageComponent ic) {
        Dimension size = ic.getCanvasSize();
        int cellSize = ic.getTransparencyChessboardCellSize();
        int patternSize = 2 * cellSize;
        BufferedImage pattern = UIUtil.createImage((int)patternSize, (int)patternSize, (int)2);
        Graphics imageGraphics = pattern.getGraphics();
        imageGraphics.setColor(ic.getTransparencyChessboardWhiteColor());
        imageGraphics.fillRect(0, 0, patternSize, patternSize);
        imageGraphics.setColor(ic.getTransparencyChessboardBlackColor());
        imageGraphics.fillRect(0, cellSize, cellSize, cellSize);
        imageGraphics.fillRect(cellSize, 0, cellSize, cellSize);
        ((Graphics2D)g).setPaint(new TexturePaint(pattern, new Rectangle(0, 0, patternSize, patternSize)));
        g.fillRect(0, 0, size.width, size.height);
    }

    private void paintImage(Graphics g, ImageComponent ic) {
        ImageDocument document2 = ic.getDocument();
        Dimension size = ic.getCanvasSize();
        Graphics2D g2d = (Graphics2D)g;
        RenderingHints oldHints = g2d.getRenderingHints();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.drawImage(document2.getRenderer(), 0, 0, size.width, size.height, ic);
        g2d.setRenderingHints(oldHints);
    }

    private void paintGrid(Graphics g, ImageComponent ic) {
        int imageHeight;
        double zoomY;
        Dimension size = ic.getCanvasSize();
        BufferedImage image = ic.getDocument().getValue();
        int imageWidth = image.getWidth();
        double zoomX = (double)size.width / (double)imageWidth;
        double zoomFactor = (zoomX + (zoomY = (double)size.height / (double)(imageHeight = image.getHeight()))) / 2.0;
        if (zoomFactor >= (double)ic.getGridLineZoomFactor()) {
            int ls;
            g.setColor(ic.getGridLineColor());
            for (int dx = ls = ic.getGridLineSpan(); dx < imageWidth; dx += ls) {
                UIUtil.drawLine((Graphics)g, (int)((int)((double)dx * zoomX)), (int)0, (int)((int)((double)dx * zoomX)), (int)size.height);
            }
            for (int dy = ls; dy < imageHeight; dy += ls) {
                UIUtil.drawLine((Graphics)g, (int)0, (int)((int)((double)dy * zoomY)), (int)size.width, (int)((int)((double)dy * zoomY)));
            }
        }
    }

    public static ComponentUI createUI(JComponent c) {
        return ui;
    }
}

