/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.NetService;

public final class ConsoleManager {
    private ConsoleView console;

    @NotNull
    public ConsoleView getConsole(@NotNull NetService netService) {
        if (netService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "netService", "org/jetbrains/builtInWebServer/ConsoleManager", "getConsole"));
        }
        if (this.console == null) {
            this.createConsole(netService);
        }
        ConsoleView consoleView = this.console;
        if (consoleView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/builtInWebServer/ConsoleManager", "getConsole"));
        }
        return consoleView;
    }

    private void createConsole(@NotNull NetService netService) {
        if (netService == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "netService", "org/jetbrains/builtInWebServer/ConsoleManager", "createConsole"));
        }
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(netService.getProject());
        netService.configureConsole(consoleBuilder);
        this.console = consoleBuilder.getConsole();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (netService == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "netService", "org/jetbrains/builtInWebServer/ConsoleManager", "lambda$createConsole$0"));
            }
            ActionGroup actionGroup = netService.getConsoleToolWindowActions();
            ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", actionGroup, false);
            SimpleToolWindowPanel toolWindowPanel = new SimpleToolWindowPanel(false, true);
            toolWindowPanel.setContent(this.console.getComponent());
            toolWindowPanel.setToolbar(toolbar.getComponent());
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)netService.getProject()).registerToolWindow(netService.getConsoleToolWindowId(), false, ToolWindowAnchor.BOTTOM, (Disposable)netService.getProject(), true);
            toolWindow.setIcon(netService.getConsoleToolWindowIcon());
            Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)toolWindowPanel, "", false);
            Disposer.register((Disposable)content, (Disposable)this.console);
            toolWindow.getContentManager().addContent(content);
        }, netService.getProject().getDisposed());
    }
}

