/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.editor.Document;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.MappingEntry;

public abstract class MappingList {
    private final List<MappingEntry> mappings;

    public MappingList(@NotNull List<MappingEntry> mappings) {
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "org/jetbrains/debugger/sourcemap/MappingList", "<init>"));
        }
        this.mappings = mappings;
    }

    public int getSize() {
        return this.mappings.size();
    }

    protected abstract Comparator<MappingEntry> getComparator();

    public abstract int getLine(@NotNull MappingEntry var1);

    public abstract int getColumn(@NotNull MappingEntry var1);

    public int indexOf(int line, int column) {
        int low = 0;
        int high = this.mappings.size() - 1;
        if (this.getLine(this.mappings.get(low)) > line || this.getLine(this.mappings.get(high)) < line) {
            return -1;
        }
        while (low <= high) {
            int middle = low + high >>> 1;
            MappingEntry mapping = this.mappings.get(middle);
            int mappingLine = this.getLine(mapping);
            if (line == mappingLine) {
                if (column == this.getColumn(mapping)) {
                    MappingEntry prevMapping;
                    int firstIndex;
                    for (firstIndex = middle; firstIndex > 0 && this.getLine(prevMapping = this.mappings.get(firstIndex - 1)) == line && this.getColumn(prevMapping) == column; --firstIndex) {
                    }
                    return firstIndex;
                }
                if (column < this.getColumn(mapping)) {
                    if (column == 0 || column == -1) {
                        int firstIndex;
                        for (firstIndex = middle; firstIndex > 0 && this.getLine(this.mappings.get(firstIndex - 1)) == line; --firstIndex) {
                        }
                        return firstIndex;
                    }
                    if (middle == 0) {
                        return -1;
                    }
                    MappingEntry prevMapping = this.mappings.get(middle - 1);
                    if (line != this.getLine(prevMapping)) {
                        return -1;
                    }
                    if (column >= this.getColumn(prevMapping)) {
                        return middle - 1;
                    }
                    high = middle - 1;
                    continue;
                }
                MappingEntry nextMapping = this.getNextOnTheSameLine(middle);
                if (nextMapping == null) {
                    return middle;
                }
                low = middle + 1;
                continue;
            }
            if (line > mappingLine) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return -1;
    }

    @Nullable
    public MappingEntry get(int line, int column) {
        int index = this.indexOf(line, column);
        return index == -1 ? null : this.mappings.get(index);
    }

    @Nullable
    public MappingEntry getNext(int index) {
        return index >= 0 && index + 1 < this.mappings.size() ? this.mappings.get(index + 1) : null;
    }

    @Nullable
    public MappingEntry getNext(@NotNull MappingEntry mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/debugger/sourcemap/MappingList", "getNext"));
        }
        return this.getNext(Collections.binarySearch(this.mappings, mapping, this.getComparator()));
    }

    @Nullable
    public MappingEntry getNextOnTheSameLine(int index) {
        return this.getNextOnTheSameLine(index, true);
    }

    @Nullable
    public MappingEntry getNextOnTheSameLine(int index, boolean skipIfColumnEquals) {
        MappingEntry nextMapping = this.getNext(index);
        if (nextMapping == null) {
            return null;
        }
        MappingEntry mapping = this.get(index);
        if (this.getLine(nextMapping) != this.getLine(mapping)) {
            return null;
        }
        if (skipIfColumnEquals) {
            while (nextMapping != null && this.getColumn(nextMapping) == this.getColumn(mapping)) {
                nextMapping = this.getNextOnTheSameLine(++index, false);
            }
        }
        return nextMapping;
    }

    @Nullable
    public MappingEntry getNextOnTheSameLine(@NotNull MappingEntry mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/debugger/sourcemap/MappingList", "getNextOnTheSameLine"));
        }
        MappingEntry nextMapping = this.getNext(mapping);
        return nextMapping != null && this.getLine(nextMapping) == this.getLine(mapping) ? nextMapping : null;
    }

    public int getEndOffset(@NotNull MappingEntry mapping, int lineStartOffset, @NotNull Document document2) {
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/debugger/sourcemap/MappingList", "getEndOffset"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/debugger/sourcemap/MappingList", "getEndOffset"));
        }
        MappingEntry nextMapping = this.getNextOnTheSameLine(Collections.binarySearch(this.mappings, mapping, this.getComparator()));
        return nextMapping == null ? document2.getLineEndOffset(this.getLine(mapping)) : lineStartOffset + this.getColumn(nextMapping);
    }

    @NotNull
    public MappingEntry get(int index) {
        MappingEntry mappingEntry = this.mappings.get(index);
        if (mappingEntry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/sourcemap/MappingList", "get"));
        }
        return mappingEntry;
    }

    public boolean processMappingsInLine(int line, @NotNull MappingsProcessorInLine entryProcessor) {
        if (entryProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entryProcessor", "org/jetbrains/debugger/sourcemap/MappingList", "processMappingsInLine"));
        }
        int low = 0;
        int high = this.mappings.size() - 1;
        while (low <= high) {
            int middle = low + high >>> 1;
            MappingEntry mapping = this.mappings.get(middle);
            int mappingLine = this.getLine(mapping);
            if (line == mappingLine) {
                MappingEntry nextEntry;
                int firstIndex;
                for (firstIndex = middle; firstIndex > 0 && this.getLine(this.mappings.get(firstIndex - 1)) == line; --firstIndex) {
                }
                MappingEntry entry = this.mappings.get(firstIndex);
                do {
                    MappingEntry mappingEntry = nextEntry = ++firstIndex < this.mappings.size() ? this.mappings.get(firstIndex) : null;
                    if (nextEntry != null && this.getLine(nextEntry) != line) {
                        nextEntry = null;
                    }
                    if (entryProcessor.process(entry, nextEntry)) continue;
                    return true;
                } while ((entry = nextEntry) != null);
                return true;
            }
            if (line > mappingLine) {
                low = middle + 1;
                continue;
            }
            high = middle - 1;
        }
        return false;
    }

    public static interface MappingsProcessorInLine {
        public boolean process(@NotNull MappingEntry var1, @Nullable MappingEntry var2);
    }
}

