/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.openapi.util.text.StringUtil;
import git4idea.rebase.GitRebaseStatus;
import git4idea.rebase.GitRebaseUtils;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GitSuccessfulRebase
extends GitRebaseStatus {
    private final SuccessType mySuccessType;

    private GitSuccessfulRebase(@NotNull SuccessType successType, @NotNull Collection<GitRebaseUtils.CommitInfo> skippedCommits) {
        if (successType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "successType", "git4idea/rebase/GitSuccessfulRebase", "<init>"));
        }
        if (skippedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedCommits", "git4idea/rebase/GitSuccessfulRebase", "<init>"));
        }
        super(GitRebaseStatus.Type.SUCCESS, skippedCommits);
        this.mySuccessType = successType;
    }

    @NotNull
    public SuccessType getSuccessType() {
        SuccessType successType = this.mySuccessType;
        if (successType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitSuccessfulRebase", "getSuccessType"));
        }
        return successType;
    }

    @NotNull
    static GitSuccessfulRebase parseFromOutput(@NotNull List<String> output, @NotNull Collection<GitRebaseUtils.CommitInfo> skippedCommits) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "git4idea/rebase/GitSuccessfulRebase", "parseFromOutput"));
        }
        if (skippedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "skippedCommits", "git4idea/rebase/GitSuccessfulRebase", "parseFromOutput"));
        }
        GitSuccessfulRebase gitSuccessfulRebase = new GitSuccessfulRebase(SuccessType.fromOutput(output), skippedCommits);
        if (gitSuccessfulRebase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitSuccessfulRebase", "parseFromOutput"));
        }
        return gitSuccessfulRebase;
    }

    static enum SuccessType {
        REBASED{

            @Override
            @NotNull
            public String formatMessage(@Nullable String currentBranch, @NotNull String baseBranch, boolean withCheckout) {
                if (baseBranch == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBranch", "git4idea/rebase/GitSuccessfulRebase$SuccessType$1", "formatMessage"));
                }
                if (withCheckout) {
                    String string = "Checked out" + SuccessType.mention(currentBranch) + " and rebased it on " + baseBranch;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitSuccessfulRebase$SuccessType$1", "formatMessage"));
                    }
                    return string;
                }
                String string = "Rebased" + SuccessType.mention(currentBranch) + " on " + baseBranch;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitSuccessfulRebase$SuccessType$1", "formatMessage"));
                }
                return string;
            }
        }
        ,
        UP_TO_DATE{

            @Override
            @NotNull
            public String formatMessage(@Nullable String currentBranch, @NotNull String baseBranch, boolean withCheckout) {
                if (baseBranch == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBranch", "git4idea/rebase/GitSuccessfulRebase$SuccessType$2", "formatMessage"));
                }
                String msg = currentBranch != null ? currentBranch + " is up-to-date" : "Up-to-date";
                String string = msg = msg + " with " + baseBranch;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitSuccessfulRebase$SuccessType$2", "formatMessage"));
                }
                return string;
            }
        }
        ,
        FAST_FORWARDED{

            @Override
            @NotNull
            public String formatMessage(@Nullable String currentBranch, @NotNull String baseBranch, boolean withCheckout) {
                if (baseBranch == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseBranch", "git4idea/rebase/GitSuccessfulRebase$SuccessType$3", "formatMessage"));
                }
                if (withCheckout) {
                    String string = "Checked out" + SuccessType.mention(currentBranch) + " and fast-forwarded it to " + baseBranch;
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitSuccessfulRebase$SuccessType$3", "formatMessage"));
                    }
                    return string;
                }
                String string = "Fast-forwarded" + SuccessType.mention(currentBranch) + " to " + baseBranch;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitSuccessfulRebase$SuccessType$3", "formatMessage"));
                }
                return string;
            }
        };


        @NotNull
        private static String mention(@Nullable String currentBranch) {
            String string = currentBranch != null ? " " + currentBranch : "";
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitSuccessfulRebase$SuccessType", "mention"));
            }
            return string;
        }

        @NotNull
        abstract String formatMessage(@Nullable String var1, @NotNull String var2, boolean var3);

        @NotNull
        public static SuccessType fromOutput(@NotNull List<String> output) {
            if (output == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "git4idea/rebase/GitSuccessfulRebase$SuccessType", "fromOutput"));
            }
            for (String line : output) {
                if (StringUtil.containsIgnoreCase((String)line, (String)"Fast-forwarded")) {
                    SuccessType successType = FAST_FORWARDED;
                    if (successType == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitSuccessfulRebase$SuccessType", "fromOutput"));
                    }
                    return successType;
                }
                if (!StringUtil.containsIgnoreCase((String)line, (String)"is up to date")) continue;
                SuccessType successType = UP_TO_DATE;
                if (successType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitSuccessfulRebase$SuccessType", "fromOutput"));
                }
                return successType;
            }
            SuccessType successType = REBASED;
            if (successType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitSuccessfulRebase$SuccessType", "fromOutput"));
            }
            return successType;
        }
    }
}

