/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.pattern;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.maddyhome.idea.copyright.CopyrightManager;
import com.maddyhome.idea.copyright.pattern.CopyrightVariablesProvider;
import com.maddyhome.idea.copyright.pattern.CopyrightVariablesProviders;
import com.maddyhome.idea.copyright.pattern.DateInfo;
import com.maddyhome.idea.copyright.pattern.FileInfo;
import com.maddyhome.idea.copyright.pattern.ModuleInfo;
import com.maddyhome.idea.copyright.pattern.ProjectInfo;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.log.SimpleLog4JLogSystem;

public class VelocityHelper {
    private static VelocityEngine instance;

    public static String evaluate(PsiFile file, Project project, Module module, String template) {
        CopyrightVariablesProvider variablesProvider;
        VirtualFile virtualFile;
        VelocityEngine engine = VelocityHelper.getEngine();
        VelocityContext vc = new VelocityContext();
        vc.put("today", (Object)new DateInfo());
        if (file != null) {
            vc.put("file", (Object)new FileInfo(file));
        }
        if (project != null) {
            vc.put("project", (Object)new ProjectInfo(project));
        }
        if (module != null) {
            vc.put("module", (Object)new ModuleInfo(module));
        }
        vc.put("username", (Object)System.getProperty("user.name"));
        if (file != null && (virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file)) != null && (variablesProvider = (CopyrightVariablesProvider)CopyrightVariablesProviders.INSTANCE.forFileType(virtualFile.getFileType())) != null) {
            HashMap<String, Object> context = new HashMap<String, Object>();
            variablesProvider.collectVariables(context, project, module, file);
            for (Map.Entry entry : context.entrySet()) {
                vc.put((String)entry.getKey(), entry.getValue());
            }
        }
        try {
            StringWriter sw = new StringWriter();
            boolean stripLineBreak = false;
            if (template.endsWith("$")) {
                template = template + VelocityHelper.getVelocitySuffix();
                stripLineBreak = true;
            }
            engine.evaluate((Context)vc, (Writer)sw, CopyrightManager.class.getName(), template);
            String result = sw.getBuffer().toString();
            return stripLineBreak ? StringUtil.trimEnd((String)result, (String)VelocityHelper.getVelocitySuffix()) : result;
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String getVelocitySuffix() {
        return "\n";
    }

    public static void verify(String text) throws Exception {
        VelocityEngine engine = VelocityHelper.getEngine();
        VelocityContext vc = new VelocityContext();
        vc.put("today", (Object)new DateInfo());
        StringWriter sw = new StringWriter();
        if (text.endsWith("$")) {
            text = text + VelocityHelper.getVelocitySuffix();
        }
        engine.evaluate((Context)vc, (Writer)sw, CopyrightManager.class.getName(), text);
    }

    private static synchronized VelocityEngine getEngine() {
        if (instance == null) {
            try {
                VelocityEngine engine = new VelocityEngine();
                ExtendedProperties extendedProperties = new ExtendedProperties();
                extendedProperties.addProperty("resource.loader", (Object)"file");
                extendedProperties.addProperty("parser.pool.size", (Object)"1");
                extendedProperties.addProperty("file.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.FileResourceLoader");
                extendedProperties.addProperty("file.resource.loader.path", (Object)(PathManager.getPluginsPath() + "/Copyright/resources"));
                extendedProperties.addProperty("runtime.log.logsystem.class", (Object)SimpleLog4JLogSystem.class.getName());
                extendedProperties.addProperty("runtime.log.logsystem.log4j.category", (Object)CopyrightManager.class.getName());
                engine.setExtendedProperties(extendedProperties);
                engine.init();
                instance = engine;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return instance;
    }

    private VelocityHelper() {
    }
}

