/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.tasks.CustomTaskState;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.TaskStateCombo;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.ui.TaskDialogPanel;
import com.intellij.tasks.ui.TaskDialogPanelProvider;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CloseTaskDialog
extends DialogWrapper {
    private static final String UPDATE_STATE_ENABLED = "tasks.close.task.update.state.enabled";
    private final Project myProject;
    private final LocalTask myTask;
    private final List<TaskDialogPanel> myPanels;
    private JPanel myPanel;
    private JLabel myTaskLabel;
    private TaskStateCombo myStateCombo;
    private JBCheckBox myUpdateState;
    private JPanel myAdditionalPanel;

    public CloseTaskDialog(Project project, LocalTask task) {
        super(project, false);
        this.myProject = project;
        this.myTask = task;
        this.$$$setupUI$$$();
        this.setTitle("Close Task");
        this.myTaskLabel.setText(TaskUtil.getTrimmedSummary((Task)task));
        this.myTaskLabel.setIcon(task.getIcon());
        if (!TaskStateCombo.stateUpdatesSupportedFor((Task)task)) {
            this.myUpdateState.setVisible(false);
            this.myStateCombo.setVisible(false);
        }
        boolean stateUpdatesEnabled = PropertiesComponent.getInstance((Project)this.myProject).getBoolean(UPDATE_STATE_ENABLED);
        this.myUpdateState.setSelected(stateUpdatesEnabled);
        this.myStateCombo.setEnabled(stateUpdatesEnabled);
        this.myUpdateState.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean selected = CloseTaskDialog.this.myUpdateState.isSelected();
                CloseTaskDialog.this.myStateCombo.setEnabled(selected);
                PropertiesComponent.getInstance((Project)CloseTaskDialog.this.myProject).setValue(CloseTaskDialog.UPDATE_STATE_ENABLED, String.valueOf(selected));
                if (selected) {
                    CloseTaskDialog.this.myStateCombo.scheduleUpdateOnce();
                }
            }
        });
        this.myStateCombo.showHintLabel(false);
        if (this.myUpdateState.isSelected()) {
            this.myStateCombo.scheduleUpdateOnce();
        }
        this.myAdditionalPanel.setLayout(new BoxLayout(this.myAdditionalPanel, 1));
        this.myPanels = TaskDialogPanelProvider.getCloseTaskPanels((Project)project, (LocalTask)task);
        for (TaskDialogPanel panel : this.myPanels) {
            this.myAdditionalPanel.add(panel.getPanel());
        }
        this.init();
    }

    protected void doOKAction() {
        for (TaskDialogPanel panel : this.myPanels) {
            panel.commit();
        }
        super.doOKAction();
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myStateCombo.isVisible() && this.myUpdateState.isSelected() ? this.myStateCombo.getComboBox() : null;
    }

    @Nullable
    CustomTaskState getCloseIssueState() {
        return this.myUpdateState.isSelected() ? this.myStateCombo.getSelectedState() : null;
    }

    private void createUIComponents() {
        this.myStateCombo = new TaskStateCombo(this.myProject, (Task)this.myTask){

            @Override
            @Nullable
            protected CustomTaskState getPreferredState(@NotNull TaskRepository repository, @NotNull Collection<CustomTaskState> available) {
                if (repository == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/intellij/tasks/actions/CloseTaskDialog$2", "getPreferredState"));
                }
                if (available == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "available", "com/intellij/tasks/actions/CloseTaskDialog$2", "getPreferredState"));
                }
                return repository.getPreferredCloseTaskState();
            }
        };
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JBCheckBox jBCheckBox;
        JLabel jLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Close task:");
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(35, 14), null));
        this.myTaskLabel = jLabel = new JLabel();
        jLabel.setText("Task description");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(2, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        TaskStateCombo taskStateCombo = this.myStateCombo;
        jPanel3.add((Component)taskStateCombo, new GridConstraints(0, 1, 1, 1, 0, 0, 3, 3, null, null, null));
        this.myUpdateState = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Update issue state");
        jBCheckBox.setMnemonic('U');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myAdditionalPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

